% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratified_split_class.R
\name{stratified_split}
\alias{stratified_split}
\title{Stratified sampling}
\usage{
stratified_split(p_train, factor_name, ...)
}
\arguments{
\item{p_train}{(numeric) The proportion of samples selected for the training set.}

\item{factor_name}{(character) The name of a sample-meta column to use.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{stratified_split} object with the following \code{output} slots:
\tabular{ll}{
\code{training} \tab          (DatasetExperiment) A DatasetExperiment object containing samples selected for the training set. \cr
\code{testing} \tab          (DatasetExperiment) A DatasetExperiment object containing samples selected for the testing set. \cr
}
}
\description{
The dataset is divided into two subsets. A predefined proportion of samples from each level of a factor is selected for the training set, and the remaining samples are used for the test set. The stratification by factor level means that the relative number of samples per level is approximately equal to the original dataset.
}
\section{Inheritance}{

A \code{stratified_split} object inherits the following \code{struct} classes: \cr\cr
\verb{[stratified_split]} >> \verb{[split_data]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = stratified_split(
      factor_name = "V1",
      p_train = 0.75)

D = iris_DatasetExperiment()
M = stratified_split(p_train=0.75,factor_name='Species')
M = model_apply(M,D)

}
