% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_prots.R
\name{graph_prots}
\alias{graph_prots}
\title{Create a plot showing where each amino acid is located within the cell for
each primary transcript compared to each alternative transcript}
\usage{
graph_prots(counts, rank = "length", n_prts = 20, size_txt = 2,
space_left = -400)
}
\arguments{
\item{counts}{A data frame containing the overall length and individual 
lengths of each section of the surface protein corresponding to a certain 
transcript.}

\item{rank}{String indicating which method to use to rank proteins in graphical
output. Options include "Length", "TM", and "Combo".}

\item{n_prts}{Integer value indicating the number of genes that should be
displayed on the graphical output. Default value is 20.}

\item{size_txt}{Integer value specifying the size of the row labels. Default
size is 2.}

\item{space_left}{Integer value specifying how far left the graph should
extend.}
}
\value{
A ggplot figure showing the protein locations for each part of the
surface protein for each alternative and primary transcripts.
}
\description{
This function creates a ggplot figure showing the differences in membrane
location and length between primary and alternative transcripts from the
same gene. Transcripts derived from the same gene are grouped together
to facilitate easy interpretation. The y axis lists the gene name and
transcript ID for each transcript and the x axis lists the length in
amino acids. Each fill color corresponds to a membrane location and either
principal or alternative isoform.
}
