% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_survclust.R
\name{cv_survclust}
\alias{cv_survclust}
\title{performs cross validation on supervised clustering, \code{survClust} for a particular \code{k}. \code{cv_survclust} runs}
\usage{
cv_survclust(datasets, survdat = NULL, k, fold, cmd.k = NULL, type = NULL)
}
\arguments{
\item{datasets}{A list object containing \code{m} data matrices representing \code{m} different genomic data types measured in a set of \code{N~m} samples.
OR \code{\link{MultiAssayExperiment}} object of desired types of data.
For list of matrices, each matrix, the rows represent samples, and the columns represent genomic features. Each data matrix is allowed to have different samples}

\item{survdat}{A matrix, containing two columns - 1st column \code{time} and 2nd column containing \code{events} information.
OR this information can be provided as a part of \code{colData} \code{MultiAssayExperiment}}

\item{k}{integer, choice of \code{k} to perform clustering on samples}

\item{fold}{integer,  number of folds to run cross validation}

\item{cmd.k}{integer, number of dimensions used by \code{cmdscale} to perform clustering on samples. Defaults is \code{n-1}}

\item{type}{Specify \code{type="mut"}, if datasets is of length \code{1} and contains \code{binary} data only.}
}
\value{
\itemize{
\item{cv.labels}{returns cross validated class labels for \code{k} cluster}
\item{cv.logrank}{logrank test statistic of cross validated label}
\item{cv.spwss}{standardized pooled within-cluster sum of squares calculated from cross-validation  class labels }
}
}
\description{
\code{cv_survclust} performs \code{k} fold cross-validation, runs \code{survClust} on each training and
hold out test fold and return cross-validated supervised cluster labels.
}
\examples{
library(survClust)
cv.fit <- cv_survclust(datasets = simdat, survdat = simsurvdat, k = 3, fold=3 )

}
\author{
Arshi Arora
}
