% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_number_decimals.R
\name{get_number_decimals}
\alias{get_number_decimals}
\title{Get number of decimals (i.e. return total number of digits after decimal point) for any vector of numbers in [0,1) if number of decimals <= 6}
\usage{
get_number_decimals(x)
}
\arguments{
\item{x}{Numerical vector where all elements are in [0,1)}
}
\value{
Vector giving the number of decimals for each element in x if the number is <= 6; otherwise return 7 with a warning
}
\description{
Get number of decimals (i.e. return total number of digits after decimal point) for any vector of numbers in [0,1) if number of decimals <= 6
}
\examples{
#get_number_decimals(c(0.0006, 0.0750, 0.0420, 0.0031, 0.0001, 0.0100))
#get_number_decimals(c(6*10^-4, 7.5*10^-2, 4.2*10^-2, 3.1*10^-3, 10^-4, 10^-2))
#get_number_decimals(c(6.5*10^-4, 0.0100)) 
#get_number_decimals(c(6.5e-4, 0.0100))
#get_number_decimals(c(0.00065, 0.0100))
#get_number_decimals(c(10^-7, 10e-7, 10e-3))
}
