% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Reshape_data.R
\name{ExtractSingleDrug}
\alias{ExtractSingleDrug}
\title{Extract Single Drug Dose Response}
\usage{
ExtractSingleDrug(response)
}
\arguments{
\item{response}{A data frame. It must contain the columns: "conc1", "conc2",
..., for the concentration of the combined drugs and "response" for the
observed \%inhibition at certain combination.}
}
\value{
A list contains several data frames each of which contains 2 columns:
  \itemize{
    \item \strong{dose} The concertration of drug.
    \item \strong{response} The cell's response (inhibation rate) to
      corresponding drug concertration.
}
}
\description{
\code{ExtractSingleDrug} extracts the dose-response values of single drug
 from a drug combination dose-response matrix.
}
\examples{
data("mathews_screening_data")
data <- ReshapeData(mathews_screening_data)
response <- data$response[data$response$block_id == 1,
                          c("conc1", "conc2", "response")]
single <- ExtractSingleDrug(response)
}
\author{
\itemize{
  \item Shuyu Zheng \email{shuyu.zheng@helsinki.fi}
  \item Jing Tang \email{jing.tang@helsinki.fi}
}
}
