% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_synergy_score.R
\name{HSA}
\alias{HSA}
\title{Calculate HSA Synergy Score}
\usage{
HSA(response)
}
\arguments{
\item{response}{A data frame. It must contain the columns: "conc1", "conc2",
..., for the concentration of the combined drugs and "response" for the
observed \%inhibition at certain combination.}
}
\value{
A data frame containing the concentrations for drugs, reference
  effect and synergy score estimated by HSA model.
}
\description{
\code{HSA} calculates the synergy score matrix for a block of
drug combination by using Highest Single Agent (HSA) reference model.
}
\details{
This model is a reference model for evaluating the combination effect of two
drugs. The basic assumption of this model is "The reference effect of drug
combination is the maximal single drug effect".
}
\examples{
data("mathews_screening_data")
data <- ReshapeData(mathews_screening_data)
response <- data$response[data$response$block_id == 1, 
                          c("conc1", "conc2", "response")]
HSA.score <- HSA(response)
}
\references{
\itemize{
   \item{Yadav B, Wennerberg K, Aittokallio T, Tang J.(2015).
   \href{https://doi.org/10.1016/j.csbj.2015.09.001}{Searching for Drug
   Synergy in Complex Dose-Response Landscape Using an Interaction Potency
   Model.}Comput Struct Biotechnol J, 13:504– 513.}
   \item{Berenbaum MC. (1989).
   \href{https://www.ncbi.nlm.nih.gov/pubmed/2692037}{What is synergy?}
   Pharmacol Rev 1990 Sep;41(3):422.
   }
}
}
\author{
\itemize{
    \item Shuyu Zheng \email{shuyu.zheng@helsinki.fi}
    \item Jing Tang \email{jing.tang@helsinki.fi}
 }
}
