% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_non_normal.R
\name{filter_non_normal}
\alias{filter_non_normal}
\title{Filter Non-Normal Exposure Variables}
\usage{
filter_non_normal(exposomicset, p_thresh = 0.05)
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} object containing
exposure and omics data.}

\item{p_thresh}{A numeric value specifying the p-value
threshold for normality. Variables with \code{p.value < p_thresh} are removed.
Default is \code{0.05}.}
}
\value{
A \code{MultiAssayExperiment} object with non-normal
exposure variables removed.
}
\description{
Removes exposure variables that deviate significantly from a
normal distribution based on
normality test results stored in metadata.
}
\details{
The function identifies exposure variables that fail a normality test
using \code{metadata(exposomicset)$transformation$norm_df}.
\itemize{
\item Exposure variables with \code{p.value < p_thresh} are removed from
\code{colData(exposomicset)}.
\item The same filtering is applied to \code{colData} in each experiment
within \code{experiments(exposomicset)}.
}
}
\examples{
# Create example data
mae <- make_example_data(
    n_samples = 20,
    return_mae = TRUE
)

# Test for normality
mae <- mae |>
    run_normality_check() |>
    transform_exposure(exposure_cols = c("age", "bmi", "exposure_pm25"))

# Remove non-normal variables
mae_filtered <- mae |>
    filter_non_normal()

}
