% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_sample_outliers.R
\name{filter_sample_outliers}
\alias{filter_sample_outliers}
\title{Filter Sample Outliers}
\usage{
filter_sample_outliers(exposomicset, outliers = NULL)
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} object containing
omics and exposure data.}

\item{outliers}{An optional character vector specifying
sample names to be removed.
If \code{NULL}, the function uses outliers identified in
\code{metadata(exposomicset)$pca$outliers}. Default is \code{NULL}.}
}
\value{
A \code{MultiAssayExperiment} object with the specified outliers removed.
}
\description{
Removes sample outliers from a \code{MultiAssayExperiment} object
based on PCA analysis.
}
\details{
The function checks for the presence of PCA results in
\code{metadata(exposomicset)}. If \code{outliers} is not provided,
it retrieves precomputed outliers from \code{metadata(exposomicset)$pca$outliers}.
The identified samples are removed
from the dataset.
}
\examples{

# create example data
mae <- make_example_data(
    n_samples = 10,
    return_mae = TRUE
)

# run PCA
mae <- mae |>
    run_pca()

# filter outliers if present
mae <- mae |>
    filter_sample_outliers()

}
