% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_sample.R
\name{pivot_sample}
\alias{pivot_sample}
\title{Extract Sample Metadata from MultiAssayExperiment or SummarizedExperiment}
\usage{
pivot_sample(x, ...)
}
\arguments{
\item{x}{A \code{MultiAssayExperiment} or \code{SummarizedExperiment} object.}

\item{...}{Additional arguments passed to \code{pivot_sample()} from \code{tidybulk}
for \code{SummarizedExperiment} objects.}
}
\value{
A tibble containing sample metadata with an added \code{.sample} column.
}
\description{
Extracts and formats sample-level metadata (\code{colData}) from a
\code{MultiAssayExperiment} or \code{SummarizedExperiment} object.
}
\details{
This function:
\itemize{
\item Extracts \strong{sample metadata} from \code{MultiAssayExperiment} using \code{colData()},
converting it to a tibble.
\item Calls \code{pivot_sample()} from \code{tidybulk} when applied to a
\code{SummarizedExperiment} object.
\item \strong{Error Handling}: Returns an error if \code{x} is not a
\code{MultiAssayExperiment} or \code{SummarizedExperiment}.
}
}
\examples{

# create example data
mae <- make_example_data(
    n_samples = 10,
    return_mae = TRUE
)

sample_data <- mae |>
    pivot_sample()

}
