% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_cluster_samples.R
\name{run_cluster_samples}
\alias{run_cluster_samples}
\title{Cluster Samples Based on Exposure Data}
\usage{
run_cluster_samples(
  exposomicset,
  exposure_cols = NULL,
  dist_method = NULL,
  user_k = NULL,
  cluster_method = "ward.D",
  clustering_approach = "diana",
  action = "add"
)
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} object containing omics
and exposure data.}

\item{exposure_cols}{A character vector of column names in
\code{colData(exposomicset)} to use for clustering.}

\item{dist_method}{A character string specifying the distance metric
(\code{"euclidean"}, \code{"gower"}, etc.). If \code{NULL}, it is automatically determined.}

\item{user_k}{An integer specifying the number of clusters.
If \code{NULL}, an optimal \code{k} is determined.}

\item{cluster_method}{A character string specifying the hierarchical
clustering method. Default is \code{"ward.D"}.}

\item{clustering_approach}{A character string specifying the method
for determining \code{k} (\code{"diana"}, \code{"gap"}, \code{"elbow"}, \code{"dynamic"},
or \code{"density"}). Default is \code{"diana"}.}

\item{action}{A character string specifying \code{"add"}
(store results in metadata) or \code{"get"} (return clustering results).
Default is \code{"add"}.}
}
\value{
If \code{action="add"}, returns the updated \code{exposomicset}.
If \code{action="get"}, returns a list with:
\item{sample_cluster}{A hierarchical clustering object (\code{hclust}).}
\item{sample_groups}{A named vector of sample cluster assignments.}
}
\description{
Performs hierarchical clustering of samples using exposure data from
\code{colData(exposomicset)}.
}
\details{
This function:
\itemize{
\item Extracts \strong{numeric exposure data} from \code{colData(exposomicset)}.
\item Computes a \strong{distance matrix} (\code{"gower"} for mixed data,
\code{"euclidean"} for numeric).
\item Determines the \strong{optimal number of clusters (\code{k})} using the
specified method.
\item Performs \strong{hierarchical clustering} (\code{hclust}) and assigns
samples to clusters.
\item Generates a \strong{heatmap} of scaled exposure values.
\item Stores results in \code{metadata(exposomicset)$sample_clustering}
when \code{action="add"}.
}
}
\examples{
# create example data
mae <- make_example_data(
    n_samples = 10,
    return_mae = TRUE
)

# determine sample clusters
mae <- run_cluster_samples(
    exposomicset = mae,
    exposure_cols = c("exposure_pm25", "exposure_no2", "age", "bmi"),
    clustering_approach = "diana"
)

}
