% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TranscriptionDataSet-generics.R,
%   R/TranscriptionDataSet-methods.R
\name{getTranscripts}
\alias{getTranscripts}
\alias{getTranscripts,TranscriptionDataSet-method}
\title{getTranscripts}
\usage{
getTranscripts(object, min.length, min.fpkm, min.coverage)

\S4method{getTranscripts}{TranscriptionDataSet}(object, min.length, min.fpkm, min.coverage)
}
\arguments{
\item{object}{A \code{\link{TranscriptionDataSet}} object.}

\item{min.length}{\code{Numeric}. A minimum length (in bp) of the reported
transcripts.}

\item{min.fpkm}{\code{Numeric}. A minimum FPKM of the reported transcripts.}

\item{min.coverage}{\code{Numeric}. A minimum coverage of the reported
transcripts.}
}
\value{
A \code{\link[GenomicRanges]{GRanges}} object.
}
\description{
Retrieve transcripts information from the \code{\link{TranscriptionDataSet}}
object.
}
\details{
The coverage is a measure of how densely the transcript is covered by the
    sequencing fragments. Modestly/highly expressed transcripts will have a
    value close to 1, whereas lowly expressed transcripts will have a value
    close to 0, indicating the sparse distribution of sequencing fragments
    along the transcript body.
}
\examples{
### Load TranscriptionDataSet object
data(tds)

### View detected transcripts
getTranscripts(tds)

}
\seealso{
\code{\link{detectTranscripts}}
}
\author{
Armen R. Karapetyan
}
