% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed_reference.R
\name{importData}
\alias{importData}
\title{Import quantification across mixed reference transcripts}
\usage{
importData(coldata, type = "oarfish", quiet = FALSE, ...)
}
\arguments{
\item{coldata}{data.frame with columns \code{files} and \code{names} as in \code{tximeta()}}

\item{type}{what quantifier was used (see \code{\link[tximport:tximport]{tximport::tximport()}}), for now
\code{importData()} works for \code{"oarfish"} files}

\item{quiet}{whether to suppress printed messages}

\item{...}{arguments passed to \code{\link[tximport:tximport]{tximport::tximport()}}}
}
\value{
an un-ranged SummarizedExperiment (SE) object, for
use with subsequent functions described in \emph{See also} section
}
\description{
The \emph{oarfish} quantification tools allows a mix of
\code{--annotated} reference transcripts (e.g. GENCODE, Ensembl) and
\code{--novel} or custom transcripts (e.g. de novo assembled transcripts not present
in the annotated set) to be used as the index for quantification.
\code{importData()} and associated functions facilitate import, reference identification,
and addition of metadata across \code{annotated} and/or \code{novel} transcripts.
The \code{importData()} function alone imports the data, while inspection of the
recognized digests and updating of transcript metadata is handled by subsequent functions
(listed in \emph{See also} section below).
}
\details{
oarfish with mixed reference transcript sets may have been generated with e.g.

\preformatted{
oarfish --only-index --annotated gencode.v48.transcripts.fa.gz \
  --novel my_novel_txps.fa.gz --seq-tech ont-cdna --threads 32 \
  --index-out gencode_plus_novel
oarfish --reads reads/experiment_rep1.fastq.gz --index gencode_plus_novel \
  --output quants/experiment_rep1 --seq-tech ont-cdna \
  --filter-group no-filters --threads 32
}
}
\examples{

# oarfish files using a mix of --annotated and --novel transcripts
dir <- system.file("extdata/oarfish", package="tximportData")
names <- paste0("rep", 2:4)
files <- file.path(dir, paste0("sgnex_h9_", names, ".quant.gz"))
coldata <- data.frame(files, names)

# returns an un-ranged SE object
se <- importData(coldata, type="oarfish")

}
\seealso{
\code{inspectDigests()} and \code{updateMetadata()} for subsequent tasks
of inspecting digest matches and updating metadata, respectively.
\code{makeLinkedTxome()} can be used to add custom metadata into the registry used
for inspecting digests and then updating transcript data. A user may
follow the workflow \code{importData()} > \code{inspectDigests()} >
\code{makeLinkedTxome()} > \code{inspectDigests()} > \code{updateMetadata()}.
See also \code{makeLinkedTxpData()} for a lightweight alternative of linking
\emph{GRanges} metadata to a digest.
}
