datacache <- new.env(hash=TRUE, parent=emptyenv())

Orthology.eg <- function() showQCData("Orthology.eg", datacache)
Orthology.eg_dbconn <- function() dbconn(datacache)
Orthology.eg_dbfile <- function() dbfile(datacache)
Orthology.eg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
Orthology.eg_dbInfo <- function() dbInfo(datacache)


.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "Orthology.eg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"OrthologyDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        

    packageStartupMessage(AnnotationDbi:::annoStartupMessages("Orthology.eg"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(Orthology.eg_dbconn())
}

