# -- Example datasets
toydata <- list(
    list(Title = "WT yeast Hi-C paired-end seq reads (R1)",
        Description = "Hi-C performed on wild-type S288C yeast strain. Only the first 100,000 reads from R1 are recovered. Data recovered from SRA run results SRR13994279.",
        BiocVersion = "3.17",
        Genome = "S288C",
        SourceType = "TXT",
        SourceUrl = "https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSM5918358",
        SourceVersion = "Aug 17 2022",
        Species = "Saccharomyces cerevisiae",
        TaxonomyId = " 4932",
        Coordinate_1_based = "FALSE",
        DataProvider = "Jacques Serizay",
        Maintainer = "Jacques Serizay <jacquesserizay@gmail.com>",
        RDataClass = "character",
        DispatchClass = "FilePath",
        RDataPath = "HiContactsData/HiC_wt_yeast.R1.fq.gz",
        Tags = "HiCData"
    ), 
    list(Title = "WT yeast Hi-C paired-end seq reads (R2)",
        Description = "Hi-C performed on wild-type S288C yeast strain. Only the first 100,000 reads from R2 are recovered. Data recovered from SRA run results SRR13994279.",
        BiocVersion = "3.17",
        Genome = "S288C",
        SourceType = "TXT",
        SourceUrl = "https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSM5918358",
        SourceVersion = "Aug 17 2022",
        Species = "Saccharomyces cerevisiae",
        TaxonomyId = " 4932",
        Coordinate_1_based = "FALSE",
        DataProvider = "Jacques Serizay",
        Maintainer = "Jacques Serizay <jacquesserizay@gmail.com>",
        RDataClass = "character",
        DispatchClass = "FilePath",
        RDataPath = "HiContactsData/HiC_wt_yeast.R2.fq.gz",
        Tags = "HiCData"
    ), 
    list(Title = "WT yeast Hi-C HiCool processing log",
        Description = "Hi-C performed on wild-type S288C yeast strain. Only the first 100,000 reads from R{1,2} are recovered. Reads were mapped onto S288c genome reference using HiCool. Data recovered from SRA run results SRR13994279.",
        BiocVersion = "3.17",
        Genome = "S288C",
        SourceType = "TXT",
        SourceUrl = "https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSM5918358",
        SourceVersion = "Aug 17 2022",
        Species = "Saccharomyces cerevisiae",
        TaxonomyId = " 4932",
        Coordinate_1_based = "FALSE",
        DataProvider = "Jacques Serizay",
        Maintainer = "Jacques Serizay <jacquesserizay@gmail.com>",
        RDataClass = "character",
        DispatchClass = "FilePath",
        RDataPath = "HiContactsData/HiC_wt_yeast.HiCool.log",
        Tags = "HiCData"
    ),
    list(Title = "WT yeast .pairs file",
        Description = "Hi-C performed on wild-type S288C yeast strain processed with tinyMapper and represented as a filtered pairs file. Data representation derived from SRA run results SRR13994279.",
        BiocVersion = "3.16",
        Genome = "S288C",
        SourceType = "TXT",
        SourceUrl = "https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSM5918358",
        SourceVersion = "Aug 17 2022",
        Species = "Saccharomyces cerevisiae",
        TaxonomyId = " 4932",
        Coordinate_1_based = "FALSE",
        DataProvider = "Jacques Serizay",
        Maintainer = "Jacques Serizay <jacquesserizay@gmail.com>",
        RDataClass = "character",
        DispatchClass = "FilePath",
        RDataPath = "HiContactsData/S288C.pairs.gz",
        Tags = "HiCData"
    ), 
    list(Title = "WT yeast .cool contact matrix @ 1kb",
       Description = "Hi-C performed on wild-type S288C yeast strain processed with tinyMapper and represented as a single-resolution .cool file. Data representation derived from SRA run results SRR13994279.",
       BiocVersion = "3.16",
       Genome = "S288C",
       SourceType = "HDF5",
       SourceUrl = "https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSM5918358",
       SourceVersion = "Aug 17 2022",
       Species = "Saccharomyces cerevisiae",
       TaxonomyId = " 4932",
       Coordinate_1_based = "FALSE",
       DataProvider = "Jacques Serizay",
       Maintainer = "Jacques Serizay <jacquesserizay@gmail.com>",
       RDataClass = "character",
       DispatchClass = "FilePath",
       RDataPath = "HiContactsData/S288C.cool",
       Tags = "HiCData"
    ), 
    list(Title = "WT yeast .mcool contact matrix",
       Description = "Hi-C performed on wild-type S288C yeast strain processed with tinyMapper and represented as a multi-resolution .mcool file. Data representation derived from SRA run results SRR13994279.",
       BiocVersion = "3.16",
       Genome = "S288C",
       SourceType = "HDF5",
       SourceUrl = "https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSM5918358",
       SourceVersion = "Aug 17 2022",
       Species = "Saccharomyces cerevisiae",
       TaxonomyId = " 4932",
       Coordinate_1_based = "FALSE",
       DataProvider = "Jacques Serizay",
       Maintainer = "Jacques Serizay <jacquesserizay@gmail.com>",
       RDataClass = "character",
       DispatchClass = "FilePath",
       RDataPath = "HiContactsData/S288C.mcool",
       Tags = "HiCData"
    ), 
    list(Title = "WT yeast .hic contact matrix",
        Description = "Hi-C performed on wild-type S288C yeast strain processed with Juicer and represented as a multi-resolution .hic file. Data representation derived from SRA run results SRR13994279.",
        BiocVersion = "3.17",
        Genome = "S288C",
        SourceType = "TXT",
        SourceUrl = "https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSM5918358",
        SourceVersion = "Aug 17 2022",
        Species = "Saccharomyces cerevisiae",
        TaxonomyId = " 4932",
        Coordinate_1_based = "FALSE",
        DataProvider = "Jacques Serizay",
        Maintainer = "Jacques Serizay <jacquesserizay@gmail.com>",
        RDataClass = "character",
        DispatchClass = "FilePath",
        RDataPath = "HiContactsData/S288C.hic",
        Tags = "HiCData"
    ), 
    list(Title = "WT yeast HiC-Pro matrix file @ 1kb",
        Description = "Hi-C performed on wild-type S288C yeast strain processed with `nf-core/hic` and represented as a single resolution matrix file. Data representation derived from SRA run results SRR13994279.",
        BiocVersion = "3.17",
        Genome = "S288C",
        SourceType = "TXT",
        SourceUrl = "https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSM5918358",
        SourceVersion = "Aug 17 2022",
        Species = "Saccharomyces cerevisiae",
        TaxonomyId = " 4932",
        Coordinate_1_based = "FALSE",
        DataProvider = "Jacques Serizay",
        Maintainer = "Jacques Serizay <jacquesserizay@gmail.com>",
        RDataClass = "character",
        DispatchClass = "FilePath",
        RDataPath = "HiContactsData/S288C.hicpro.matrix",
        Tags = "HiCData"
    ), 
    list(Title = "WT yeast HiC-Pro bed file @ 1kb",
        Description = "Hi-C performed on wild-type S288C yeast strain processed with `nf-core/hic` and represented as a single resolution bed file. Data representation derived from SRA run results SRR13994279.",
        BiocVersion = "3.17",
        Genome = "S288C",
        SourceType = "TXT",
        SourceUrl = "https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSM5918358",
        SourceVersion = "Aug 17 2022",
        Species = "Saccharomyces cerevisiae",
        TaxonomyId = " 4932",
        Coordinate_1_based = "FALSE",
        DataProvider = "Jacques Serizay",
        Maintainer = "Jacques Serizay <jacquesserizay@gmail.com>",
        RDataClass = "character",
        DispatchClass = "FilePath",
        RDataPath = "HiContactsData/S288C.hicpro.bed",
        Tags = "HiCData"
    ), 
    list(Title = "WT yeast HiC-Pro bed file @ 1kb",
        Description = "Hi-C performed on wild-type S288C yeast strain processed with `nf-core/hic` and represented as a single resolution bed file. Data representation derived from SRA run results SRR13994279.",
        BiocVersion = "3.17",
        Genome = "S288C",
        SourceType = "TXT",
        SourceUrl = "https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSM5918358",
        SourceVersion = "Aug 17 2022",
        Species = "Saccharomyces cerevisiae",
        TaxonomyId = " 4932",
        Coordinate_1_based = "FALSE",
        DataProvider = "Jacques Serizay",
        Maintainer = "Jacques Serizay <jacquesserizay@gmail.com>",
        RDataClass = "character",
        DispatchClass = "FilePath",
        RDataPath = "HiContactsData/S288C.hicpro.allValidPairs",
        Tags = "HiCData"
    ), 
    list(Title = "Eco1-AID yeast .mcool contact matrix",
        Description = "Hi-C performed on Eco1-AID mutant yeast strain upon IAA treatment processed with tinyMapper and represented as a multi-resolution mcool file. Data representation derived from SRA run results SRR16250953.",
        BiocVersion = "3.16",
        Genome = "S288C",
        SourceType = "HDF5",
        SourceUrl = "https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSM5918405",
        SourceVersion = "Aug 17 2022",
        Species = "Saccharomyces cerevisiae",
        TaxonomyId = " 4932",
        Coordinate_1_based = "FALSE",
        DataProvider = "Jacques Serizay",
        Maintainer = "Jacques Serizay <jacquesserizay@gmail.com>",
        RDataClass = "character",
        DispatchClass = "FilePath",
        RDataPath = "HiContactsData/S288C_Eco1-AID.mcool",
        Tags = "HiCData"
    ), 
    list(Title = "Eco1-AID yeast .pairs file",
        Description = "Hi-C performed on Eco1-AID mutant yeast strain upon IAA treatment processed with tinyMapper and represented as a filtered pairs file. Data representation derived from SRA run results SRR16250953.",
        BiocVersion = "3.16",
        Genome = "S288C",
        SourceType = "Zip",
        SourceUrl = "https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSM5918405",
        SourceVersion = "Aug 17 2022",
        Species = "Saccharomyces cerevisiae",
        TaxonomyId = " 4932",
        Coordinate_1_based = "FALSE",
        DataProvider = "Jacques Serizay",
        Maintainer = "Jacques Serizay <jacquesserizay@gmail.com>",
        RDataClass = "character",
        DispatchClass = "FilePath",
        RDataPath = "HiContactsData/S288C_Eco1-AID.pairs.gz",
        Tags = "HiCData"
    ), 
    list(Title = "WT yeast (G1) .mcool file",
        Description = "Hi-C performed on WT S288c yeast strain synchronized in G1 phase, processed with tinyMapper and represented as a multi-res. mcool file.",
        BiocVersion = "3.19",
        Genome = "S288C",
        SourceType = "Zip",
        SourceUrl = "https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSM5918405",
        SourceVersion = "Jan 12 2024",
        Species = "Saccharomyces cerevisiae",
        TaxonomyId = " 4932",
        Coordinate_1_based = "FALSE",
        DataProvider = "Jacques Serizay",
        Maintainer = "Jacques Serizay <jacquesserizay@gmail.com>",
        RDataClass = "character",
        DispatchClass = "FilePath",
        RDataPath = "HiContactsData/S288C_G1.mcool",
        Tags = "HiCData"
    ), 
    list(Title = "WT yeast (G2M) .mcool file",
        Description = "Hi-C performed on WT S288c yeast strain synchronized in G2M phase, processed with tinyMapper and represented as a multi-res. mcool file.",
        BiocVersion = "3.19",
        Genome = "S288C",
        SourceType = "Zip",
        SourceUrl = "https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSM5918405",
        SourceVersion = "Jan 12 2024",
        Species = "Saccharomyces cerevisiae",
        TaxonomyId = " 4932",
        Coordinate_1_based = "FALSE",
        DataProvider = "Jacques Serizay",
        Maintainer = "Jacques Serizay <jacquesserizay@gmail.com>",
        RDataClass = "character",
        DispatchClass = "FilePath",
        RDataPath = "HiContactsData/S288C_G2M.mcool",
        Tags = "HiCData"
    ), 
    list(Title = "WT yeast (G1) .pairs file",
        Description = "Hi-C performed on WT S288c yeast strain synchronized in G1 phase, processed with tinyMapper and represented as a pairs file.",
        BiocVersion = "3.19",
        Genome = "S288C",
        SourceType = "Zip",
        SourceUrl = "https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSM5918405",
        SourceVersion = "Jan 12 2024",
        Species = "Saccharomyces cerevisiae",
        TaxonomyId = " 4932",
        Coordinate_1_based = "FALSE",
        DataProvider = "Jacques Serizay",
        Maintainer = "Jacques Serizay <jacquesserizay@gmail.com>",
        RDataClass = "character",
        DispatchClass = "FilePath",
        RDataPath = "HiContactsData/S288C_G1.pairs",
        Tags = "HiCData"
    ), 
    list(Title = "WT yeast (G2M) .pairs file",
        Description = "Hi-C performed on WT S288c yeast strain synchronized in G2M phase, processed with tinyMapper and represented as a pairs file.",
        BiocVersion = "3.19",
        Genome = "S288C",
        SourceType = "Zip",
        SourceUrl = "https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSM5918405",
        SourceVersion = "Jan 12 2024",
        Species = "Saccharomyces cerevisiae",
        TaxonomyId = " 4932",
        Coordinate_1_based = "FALSE",
        DataProvider = "Jacques Serizay",
        Maintainer = "Jacques Serizay <jacquesserizay@gmail.com>",
        RDataClass = "character",
        DispatchClass = "FilePath",
        RDataPath = "HiContactsData/S288C_G2M.pairs",
        Tags = "HiCData"
    ), 
    list(Title = "mESC .mcool contact matrix",
        Description = "Hi-C performed on mouse embryonic stem cells (mESCs) processed with tinyMapper and represented as a multi-resolution mcool file. Data representation derived from SRA run results SRR5339749.",
        BiocVersion = "3.16",
        Genome = "mm10",
        SourceType = "HDF5",
        SourceUrl = "https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSM2533818",
        SourceVersion = "Aug 17 2022",
        Species = "Mus musculus",
        TaxonomyId = "10090",
        Coordinate_1_based = "FALSE",
        DataProvider = "Jacques Serizay",
        Maintainer = "Jacques Serizay <jacquesserizay@gmail.com>",
        RDataClass = "character",
        DispatchClass = "FilePath",
        RDataPath = "HiContactsData/mESCs.mcool",
        Tags = "HiCData"
    ), 
    list(Title = "mESC .pairs file",
        Description = "Hi-C performed on mouse embryonic stem cells (mESCs) processed with tinyMapper and represented as a filtered pairs file. Data representation derived from SRA run results SRR5339749.",
        BiocVersion = "3.16",
        Genome = "mm10",
        SourceType = "TXT",
        SourceUrl = "https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSM2533818",
        SourceVersion = "Aug 17 2022",
        Species = "Mus musculus",
        TaxonomyId = "10090",
        Coordinate_1_based = "FALSE",
        DataProvider = "Jacques Serizay",
        Maintainer = "Jacques Serizay <jacquesserizay@gmail.com>",
        RDataClass = "character",
        DispatchClass = "FilePath",
        RDataPath = "HiContactsData/mESCs.pairs.gz",
        Tags = "HiCData"
    ), 
    list(Title = "HFFc6 .mcool contact matrix",
        Description = "Hi-C performed on Human foreskin fibroblast cell line (HFFc6). Data obtained from 4DN data portal (ID 4DNFI9FVHJZQ) and filtered to only retain chr17.",
        BiocVersion = "3.19",
        Genome = "GRCh38",
        SourceType = "HDF5",
        SourceUrl = "https://data.4dnucleome.org/files-processed/4DNFI9FVHJZQ/",
        SourceVersion = "Aug 17 2022",
        Species = "Homo sapiens",
        TaxonomyId = "9606",
        Coordinate_1_based = "FALSE",
        DataProvider = "Jacques Serizay",
        Maintainer = "Jacques Serizay <jacquesserizay@gmail.com>",
        RDataClass = "character",
        DispatchClass = "FilePath",
        RDataPath = "HiContactsData/microC_HFFc6_chr17.mcool",
        Tags = "HiCData"
    )
)
toydata <- do.call(rbind, toydata) |> as.data.frame() |> apply(2, unlist) |> as.data.frame()
toydata$BiocVersion <- as.numeric(toydata$BiocVersion)
toydata$TaxonomyId <- as.numeric(toydata$TaxonomyId)

# -- Cat everything
write.csv(toydata, file = "inst/extdata/metadata.csv", row.names = FALSE)
