% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easierData_retrieval.R
\name{get_Mariathasan2018_PDL1_treatment}
\alias{get_Mariathasan2018_PDL1_treatment}
\title{Get the Mariathasan2018 PD-L1 treatment data}
\source{
IMvigor210CoreBiologies package under the CC-BY license.
http://research-pub.gene.com/IMvigor210CoreBiologies/
}
\usage{
get_Mariathasan2018_PDL1_treatment()
}
\value{
A \linkS4class{SummarizedExperiment} object with counts
and TPM quantifications.
}
\description{
Obtain the gene expression data (count and tpm values)
and the sample metadata from Mariathasan et al. (2018).
}
\details{
The \code{SummarizedExperiment} object returned contains:
\itemize{
\item two assays: \code{counts} and \code{tpm}.
\item additional sample metadata in the \code{colData} slot, including
pat_id (the id of the patient in the original study), BOR to
PD-L1 treatment, and TMB (Tumor Mutational Burden).
}
}
\examples{
if (interactive()) {
    se_mariathasan <- get_Mariathasan2018_PDL1_treatment()
}
}
\references{
Óscar Lapuente-Santana, Maisa van Genderen, Peter A. J. Hilbers,
Francesca Finotello, and Federica Eduati. 2021. Interpretable Systems
Biomarkers Predict Response to Immune-Checkpoint Inhibitors.
Patterns, 100293. https://doi.org/10.1016/j.patter.2021.100293.

Mariathasan, S., Turley, S., Nickles, D. et al. TGFB attenuates
tumour response to PD-L1 blockade by contributing to exclusion of T cells.
Nature 554, 544–548 (2018). https://doi.org/10.1038/nature25501.
}
