% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_spatial.R
\name{geom_spatial}
\alias{geom_spatial}
\title{A ggplot2 layer for visualizing the Visium histology}
\usage{
geom_spatial(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = FALSE,
  ...
)
}
\arguments{
\item{mapping}{Passed to \code{ggplot2::layer(mapping)} where \code{grob}, \code{x} and \code{y}
are required.}

\item{data}{Passed to \code{ggplot2::layer(data)}.}

\item{stat}{Passed to \code{ggplot2::layer(stat)}.}

\item{position}{Passed to \code{ggplot2::layer(position)}.}

\item{na.rm}{Passed to \code{ggplot2::layer(params = list(na.rm))}.}

\item{show.legend}{Passed to \code{ggplot2::layer(show.legend)}.}

\item{inherit.aes}{Passed to \code{ggplot2::layer(inherit.aes)}.}

\item{...}{Other arguments passed to \code{ggplot2::layer(params = list(...))}.}
}
\value{
A \code{\link[ggplot2:layer]{ggplot2::layer()}} for the histology information.
}
\description{
This function defines a \code{\link[ggplot2:layer]{ggplot2::layer()}} for visualizing the histology
image from Visium. It can be combined with other ggplot2 functions for
visualizing the clusters as in \code{\link[=vis_clus_p]{vis_clus_p()}} or gene-level information
as in \code{\link[=vis_gene_p]{vis_gene_p()}}.
}
\examples{

if (enough_ram()) {
    ## Obtain the necessary data
    if (!exists("spe")) spe <- fetch_data("spe")

    ## Select the first sample and extract the data
    sample_id <- unique(spe$sample_id)[1]
    spe_sub <- spe[, spe$sample_id == sample_id]
    sample_df <- as.data.frame(colData(spe_sub), optional = TRUE)

    ## Obtain the histology image
    img <- SpatialExperiment::imgRaster(spe_sub)

    ## Transform to a rasterGrob object
    grob <- grid::rasterGrob(img, width = grid::unit(1, "npc"), height = grid::unit(1, "npc"))

    ## Make a plot using geom_spatial
    p <- ggplot2::ggplot(
        sample_df,
        ggplot2::aes(
            x = pxl_col_in_fullres * SpatialExperiment::scaleFactors(spe_sub),
            y = pxl_row_in_fullres * SpatialExperiment::scaleFactors(spe_sub),
        )
    ) +
        geom_spatial(
            data = tibble::tibble(grob = list(grob)),
            ggplot2::aes(grob = grob),
            x = 0.5,
            y = 0.5
        )

    ## Show the plot
    print(p)

    ## Clean up
    rm(spe_sub)
}
}
\author{
10x Genomics
}
