% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registration_block_cor.R
\name{registration_block_cor}
\alias{registration_block_cor}
\title{Spatial registration: block correlation}
\usage{
registration_block_cor(
  sce_pseudo,
  registration_model,
  var_sample_id = "registration_sample_id"
)
}
\arguments{
\item{sce_pseudo}{The output of \code{registration_pseudobulk()}.}

\item{registration_model}{The output from \code{registration_model()}.}

\item{var_sample_id}{A \code{character(1)} specifying the \code{colData(sce_pseudo)}
variable with the sample ID.}
}
\value{
A \code{numeric(1)} with the block correlation at the sample ID level.
}
\description{
This function computes the block correlation using the sample ID as the
blocking factor. This takes into account that cells in scRNA-seq data or
spots in spatially-resolved transcriptomics data from Visium (or similar)
have a sample ID batch effect.
}
\examples{
example("registration_model", package = "spatialLIBD")
block_cor <- registration_block_cor(sce_pseudo, registration_mod)
}
\seealso{
Other spatial registration and statistical modeling functions: 
\code{\link{registration_model}()},
\code{\link{registration_pseudobulk}()},
\code{\link{registration_stats_anova}()},
\code{\link{registration_stats_enrichment}()},
\code{\link{registration_stats_pairwise}()},
\code{\link{registration_wrapper}()}
}
\concept{spatial registration and statistical modeling functions}
