/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.biojava.bio.gui.sequence.FeatureRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class BasicFeatureRenderer
extends AbstractChangeable
implements FeatureRenderer {
    public static final ChangeType FILL = new ChangeType("The fill paint has changed", "org.biojava.bio.gui.sequence.BasicFeatureRenderer", "FILL");
    public static final ChangeType OUTLINE = new ChangeType("The outline paint has changed", "org.biojava.bio.gui.sequence.BasicFeatureRenderer", "OUTLINE");
    public static final ChangeType SIZE = new ChangeType("The size of the arrow has changed", "org.biojava.bio.gui.sequence.BasicFeatureRenderer", "SIZE");
    public static final ChangeType SCOOP = new ChangeType("The scoop of the arror has changed", "org.biojava.bio.gui.sequence.BasicFeatureRenderer", "SCOOP");
    private Paint fill = Color.red;
    private Paint outline = Color.black;
    private double arrowSize = 15.0;
    private double arrowScoop = 4.0;

    public double getArrowScoop() {
        return this.arrowScoop;
    }

    public double getArrowSize() {
        return this.arrowSize;
    }

    public double getDepth(SequenceRenderContext sequenceRenderContext, RangeLocation rangeLocation) {
        return this.arrowSize + 2.0 * this.arrowScoop + 1.0;
    }

    public Paint getFill() {
        return this.fill;
    }

    public Paint getOutline() {
        return this.outline;
    }

    public FeatureHolder processMouseEvent(FeatureHolder featureHolder, SequenceRenderContext sequenceRenderContext, MouseEvent mouseEvent) {
        return featureHolder;
    }

    public void renderFeature(Graphics2D graphics2D, Feature feature, SequenceRenderContext sequenceRenderContext) {
        Shape shape = null;
        Location location = feature.getLocation();
        float f = (float)sequenceRenderContext.sequenceToGraphics(location.getMin());
        float f2 = (float)sequenceRenderContext.sequenceToGraphics(location.getMax());
        float f3 = (float)(this.arrowSize + 2.0 * this.arrowScoop);
        if ((double)(f2 - f) >= this.arrowSize && feature instanceof StrandedFeature) {
            StrandedFeature.Strand strand = ((StrandedFeature)feature).getStrand();
            if (sequenceRenderContext.getDirection() == 0) {
                float f4 = 0.0f;
                float f5 = f3;
                float f6 = f4 + (float)this.arrowScoop;
                float f7 = f5 - (float)this.arrowScoop;
                float f8 = (f4 + f5) * 0.5f;
                float f9 = f;
                float f10 = f2;
                if (strand == StrandedFeature.POSITIVE) {
                    float f11 = f10 - (float)this.arrowSize;
                    GeneralPath generalPath = new GeneralPath();
                    generalPath.moveTo(f9, f6);
                    generalPath.lineTo(f11, f6);
                    generalPath.lineTo(f11, f4);
                    generalPath.lineTo(f10, f8);
                    generalPath.lineTo(f11, f5);
                    generalPath.lineTo(f11, f7);
                    generalPath.lineTo(f9, f7);
                    generalPath.closePath();
                    shape = generalPath;
                } else if (strand == StrandedFeature.NEGATIVE) {
                    float f12 = f9 + (float)this.arrowSize;
                    GeneralPath generalPath = new GeneralPath();
                    generalPath.moveTo(f10, f6);
                    generalPath.lineTo(f12, f6);
                    generalPath.lineTo(f12, f4);
                    generalPath.lineTo(f9, f8);
                    generalPath.lineTo(f12, f5);
                    generalPath.lineTo(f12, f7);
                    generalPath.lineTo(f10, f7);
                    generalPath.closePath();
                    shape = generalPath;
                }
            } else {
                float f13 = 0.0f;
                float f14 = f3;
                float f15 = f13 + (float)this.arrowScoop;
                float f16 = f14 - (float)this.arrowScoop;
                float f17 = (f13 + f14) * 0.5f;
                float f18 = f;
                float f19 = f2;
                if (strand == StrandedFeature.POSITIVE) {
                    float f20 = f19 - (float)this.arrowSize;
                    GeneralPath generalPath = new GeneralPath();
                    generalPath.moveTo(f15, f18);
                    generalPath.lineTo(f15, f20);
                    generalPath.lineTo(f13, f20);
                    generalPath.lineTo(f17, f19);
                    generalPath.lineTo(f14, f20);
                    generalPath.lineTo(f16, f20);
                    generalPath.lineTo(f16, f18);
                    generalPath.closePath();
                    shape = generalPath;
                } else if (strand == StrandedFeature.NEGATIVE) {
                    float f21 = f18 + (float)this.arrowSize;
                    GeneralPath generalPath = new GeneralPath();
                    generalPath.moveTo(f15, f19);
                    generalPath.lineTo(f15, f21);
                    generalPath.lineTo(f13, f21);
                    generalPath.lineTo(f17, f18);
                    generalPath.lineTo(f14, f21);
                    generalPath.lineTo(f16, f21);
                    generalPath.lineTo(f16, f19);
                    generalPath.closePath();
                    shape = generalPath;
                }
            }
        }
        if (shape == null) {
            shape = sequenceRenderContext.getDirection() == 0 ? new Rectangle2D.Double(f, 0.0, f2 - f, 2.0 * this.arrowScoop + this.arrowSize) : new Rectangle2D.Double(0.0, f, 2.0 * this.arrowScoop + this.arrowSize, f2 - f);
        }
        if (this.fill != null) {
            graphics2D.setPaint(this.fill);
            graphics2D.fill(shape);
        }
        if (this.outline != null) {
            graphics2D.setPaint(this.outline);
            graphics2D.draw(shape);
        }
    }

    public void setArrowScoop(double d) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(SequenceRenderContext.LAYOUT);
            synchronized (changeSupport2) {
                ChangeEvent changeEvent = new ChangeEvent(this, SequenceRenderContext.LAYOUT, null, null, new ChangeEvent(this, SIZE, new Double(this.arrowSize), new Double(this.arrowSize)));
                changeSupport.firePreChangeEvent(changeEvent);
                this.arrowScoop = d;
                changeSupport.firePostChangeEvent(changeEvent);
            }
        } else {
            this.arrowScoop = d;
        }
    }

    public void setArrowSize(double d) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(SequenceRenderContext.LAYOUT);
            synchronized (changeSupport2) {
                ChangeEvent changeEvent = new ChangeEvent(this, SequenceRenderContext.LAYOUT, null, null, new ChangeEvent(this, SIZE, new Double(this.arrowSize), new Double(d)));
                changeSupport.firePreChangeEvent(changeEvent);
                this.arrowSize = d;
                changeSupport.firePostChangeEvent(changeEvent);
            }
        } else {
            this.arrowSize = d;
        }
    }

    public void setFill(Paint paint) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(SequenceRenderContext.REPAINT);
            synchronized (changeSupport2) {
                ChangeEvent changeEvent = new ChangeEvent(this, SequenceRenderContext.REPAINT, null, null, new ChangeEvent(this, FILL, paint, this.fill));
                changeSupport.firePreChangeEvent(changeEvent);
                this.fill = paint;
                changeSupport.firePostChangeEvent(changeEvent);
            }
        } else {
            this.fill = paint;
        }
    }

    public void setOutline(Paint paint) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(SequenceRenderContext.REPAINT);
            synchronized (changeSupport2) {
                ChangeEvent changeEvent = new ChangeEvent(this, SequenceRenderContext.REPAINT, null, null, new ChangeEvent(this, OUTLINE, paint, this.outline));
                changeSupport.firePreChangeEvent(changeEvent);
                this.outline = paint;
                changeSupport.firePostChangeEvent(changeEvent);
            }
        } else {
            this.outline = paint;
        }
    }
}

