## ----include=FALSE------------------------------------------------------------
library(BiocStyle)
knitr::opts_chunk$set(echo = TRUE, fig.align = "center", message = FALSE, warning = FALSE)

## ----eval = FALSE-------------------------------------------------------------
# if (!requireNamespace("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# BiocManager::install("CRISPRball")

## ----eval = FALSE-------------------------------------------------------------
# library("CRISPRball")
# CRISPRball()

## ----fig.cap="Screenshot of the `CRISPRball` application, when launched as a server where users can directly upload MAGeCK RRA or MLE output. Information on the format of the expected data are provided in the following sections.", echo=FALSE----
knitr::include_graphics("upload_cb.png")

## -----------------------------------------------------------------------------
# Create lists of results summaries for each dataset.
d1.genes <- read.delim(system.file("extdata", "esc1.gene_summary.txt",
    package = "CRISPRball"
), check.names = FALSE)
d2.genes <- read.delim(system.file("extdata", "plasmid.gene_summary.txt",
    package = "CRISPRball"
), check.names = FALSE)

d1.sgrnas <- read.delim(system.file("extdata", "esc1.sgrna_summary.txt",
    package = "CRISPRball"
), check.names = FALSE)
d2.sgrnas <- read.delim(system.file("extdata", "plasmid.sgrna_summary.txt",
    package = "CRISPRball"
), check.names = FALSE)

count.summ <- read.delim(system.file("extdata", "escneg.countsummary.txt",
    package = "CRISPRball"
), check.names = FALSE)
norm.counts <- read.delim(system.file("extdata", "escneg.count_normalized.txt",
    package = "CRISPRball"
), check.names = FALSE)

# Look at the first few rows of the gene summary for the ESC vs plasmid comparison.
head(d1.genes)

## ----eval = FALSE-------------------------------------------------------------
# genes <- list(ESC = d1.genes, plasmid = d2.genes)
# sgrnas <- list(ESC = d1.sgrnas, plasmid = d2.sgrnas)
# 
# CRISPRball(
#     gene.data = genes, sgrna.data = sgrnas,
#     count.summary = count.summ, norm.counts = norm.counts
# )

## ----eval = FALSE-------------------------------------------------------------
# # Create lists of results summaries for each dataset.
# genes <- read_mle_gene_summary(system.file("extdata", "beta_leukemia.gene_summary.txt",
#     package = "CRISPRball"
# ))
# 
# count.summ <- read.delim(system.file("extdata", "escneg.countsummary.txt",
#     package = "CRISPRball"
# ), check.names = FALSE)
# norm.counts <- read.delim(system.file("extdata", "escneg.count_normalized.txt",
#     package = "CRISPRball"
# ), check.names = FALSE)
# 
# CRISPRball(
#     gene.data = genes,
#     count.summary = count.summ, norm.counts = norm.counts
# )

## ----fig.cap="Screenshot of the `CRISPRball` application, when launched with MAGeCk RRA output provided.", echo=FALSE----
knitr::include_graphics("rra_qc_cb.png")

## ----fig.cap="Screenshot of the `CRISPRball` Gene (Overview) tab.", echo=FALSE----
knitr::include_graphics("gene_cb.png")

## ----eval = FALSE-------------------------------------------------------------
# library("msigdbr")
# 
# # Retrieve MSigDB Hallmark gene sets and convert to a named list.
# gene.sets <- msigdbr(species = "Homo sapiens", category = "H")
# gene.sets <- gene.sets %>% split(x = .$gene_symbol, f = .$gs_name)
# 
# # Can also add genesets manually.
# gene.sets[["my_fav_genes"]] <- c("TOP2A", "FECH", "SOX2", "DUT", "RELA")
# 
# CRISPRball(
#     gene.data = genes, sgrna.data = sgrnas, count.summary = count.summ,
#     norm.counts = norm.counts, genesets = gene.sets
# )

## ----eval = FALSE-------------------------------------------------------------
# library("depmap")
# library("pool")
# library("RSQLite")
# 
# # This will take a few minutes to run.
# # The database will be named "depmap_db.sqlite" and placed in the working directory.
# build_depmap_db()
# 
# CRISPRball(
#     gene.data = genes, sgrna.data = sgrnas, count.summary = count.summ,
#     norm.counts = norm.counts, genesets = gene.sets, depmap.db = "depmap_db.sqlite"
# )

## ----fig.cap="Screenshot of the `CRISPRball` application, with focus on the DepMap tab for CDK2.", echo=FALSE----
knitr::include_graphics("depmap_cb.png")

## ----echo = FALSE-------------------------------------------------------------
sessionInfo()

