## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    dpi = 900,
    out.width = "100%",
    message = FALSE,
    warning = FALSE,
    crop = NULL)

## Related to https://stat.ethz.ch/pipermail/bioc-devel/2020-April/016656.html

## ----"install", eval = FALSE--------------------------------------------------
# if (!requireNamespace("BiocManager", quietly = TRUE)) {
#     install.packages("BiocManager")
# }
# 
# BiocManager::install("chevreulShiny")
# 

## ----message=FALSE------------------------------------------------------------

library("chevreulShiny")

# Load the data
data("small_example_dataset")

## ----"start", message=FALSE, eval = FALSE-------------------------------------
# 
# minimalChevreulApp(small_example_dataset)
# 

## ----reproduce3, echo=FALSE-------------------------------------------------------------------------------------------
## Session info
options(width = 120)
sessionInfo()

