/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.keysearch;

import edu.rit.crypto.blockcipher.AES256Cipher;
import edu.rit.pj.Comm;
import edu.rit.util.Hex;

public class FindKeySeq2 {
    static byte[] plaintext;
    static byte[] ciphertext;
    static byte[] partialkey;
    static int n;
    static long keylsbs;
    static long maxcounter;
    static byte[] foundkey;
    static byte[] trialkey;
    static byte[] trialciphertext;
    static AES256Cipher cipher;

    private FindKeySeq2() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l;
        long l2 = System.currentTimeMillis();
        Comm.init(stringArray);
        if (stringArray.length != 4) {
            FindKeySeq2.usage();
        }
        plaintext = Hex.toByteArray(stringArray[0]);
        ciphertext = Hex.toByteArray(stringArray[1]);
        partialkey = Hex.toByteArray(stringArray[2]);
        n = Integer.parseInt(stringArray[3]);
        if (n < 0) {
            System.err.println("n = " + n + " is too small");
            System.exit(1);
        }
        if (n > 63) {
            System.err.println("n = " + n + " is too large");
            System.exit(1);
        }
        keylsbs = ((long)partialkey[24] & 0xFFL) << 56 | ((long)partialkey[25] & 0xFFL) << 48 | ((long)partialkey[26] & 0xFFL) << 40 | ((long)partialkey[27] & 0xFFL) << 32 | ((long)partialkey[28] & 0xFFL) << 24 | ((long)partialkey[29] & 0xFFL) << 16 | ((long)partialkey[30] & 0xFFL) << 8 | (long)partialkey[31] & 0xFFL;
        maxcounter = (1L << n) - 1L;
        foundkey = new byte[32];
        trialkey = new byte[32];
        System.arraycopy(partialkey, 0, trialkey, 0, 32);
        trialciphertext = new byte[16];
        cipher = new AES256Cipher(trialkey);
        for (l = 0L; l <= maxcounter; ++l) {
            long l3 = keylsbs | l;
            FindKeySeq2.trialkey[24] = (byte)(l3 >>> 56);
            FindKeySeq2.trialkey[25] = (byte)(l3 >>> 48);
            FindKeySeq2.trialkey[26] = (byte)(l3 >>> 40);
            FindKeySeq2.trialkey[27] = (byte)(l3 >>> 32);
            FindKeySeq2.trialkey[28] = (byte)(l3 >>> 24);
            FindKeySeq2.trialkey[29] = (byte)(l3 >>> 16);
            FindKeySeq2.trialkey[30] = (byte)(l3 >>> 8);
            FindKeySeq2.trialkey[31] = (byte)l3;
            cipher.setKey(trialkey);
            cipher.encrypt(plaintext, trialciphertext);
            if (!FindKeySeq2.match(ciphertext, trialciphertext)) continue;
            System.arraycopy(trialkey, 0, foundkey, 0, 32);
            break;
        }
        l = System.currentTimeMillis();
        System.out.println(Hex.toString(foundkey));
        System.out.println(l - l2 + " msec");
    }

    private static boolean match(byte[] byArray, byte[] byArray2) {
        boolean bl = true;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            bl = bl && byArray[i] == byArray2[i];
        }
        return bl;
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.clu.keysearch.FindKeySeq2 <plaintext> <ciphertext> <partialkey> <n>");
        System.err.println("<plaintext> = Plaintext (128-bit hexadecimal number)");
        System.err.println("<ciphertext> = Ciphertext (128-bit hexadecimal number)");
        System.err.println("<partialkey> = Partial key (256-bit hexadecimal number)");
        System.err.println("<n> = Number of key bits to search for");
        System.exit(1);
    }
}

