/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mri;

import edu.rit.mri.PixelSignal;
import edu.rit.mri.SignalDataSetWriter;
import edu.rit.numeric.ListSeries;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Scanner;

public class CreateSignalDataSet {
    private CreateSignalDataSet() {
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        if (stringArray.length != 3) {
            CreateSignalDataSet.usage();
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        File file3 = new File(stringArray[2]);
        Scanner scanner = new Scanner(file);
        Scanner scanner2 = new Scanner(scanner.nextLine());
        int n2 = scanner2.nextInt();
        int n3 = scanner2.nextInt();
        int n4 = n2 * n3;
        ListSeries listSeries = new ListSeries();
        ArrayList<File> arrayList = new ArrayList<File>();
        while (scanner.hasNextLine()) {
            scanner2 = new Scanner(scanner.nextLine());
            listSeries.add(scanner2.nextDouble());
            arrayList.add(new File(scanner2.next()));
        }
        scanner.close();
        int n5 = listSeries.length();
        boolean[] blArray = new boolean[n4];
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(2 * n4);
        CreateSignalDataSet.fillBuffer(byteBuffer, file2);
        byte by = byteBuffer.get();
        byte by2 = byteBuffer.get();
        if (by == 0 && by2 == 1) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else if (by == 1 && by2 == 0) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            throw new IOException("Illegal start of mask file \"" + file2 + "\": " + by + ", " + by2);
        }
        for (int i = 1; i < n4; ++i) {
            n = byteBuffer.getShort();
            if (n == 0) {
                blArray[i] = false;
                continue;
            }
            if (n == 1) {
                blArray[i] = true;
                continue;
            }
            throw new IOException("Illegal value " + n + " for pixel " + i + " in mask file \"" + file2 + "\"");
        }
        short[][] sArrayArray = new short[n4][];
        for (n = 0; n < n4; ++n) {
            if (!blArray[n]) continue;
            sArrayArray[n] = new short[n5];
        }
        for (n = 0; n < n5; ++n) {
            File file4 = (File)arrayList.get(n);
            CreateSignalDataSet.fillBuffer(byteBuffer, file4);
            by = byteBuffer.get();
            by2 = byteBuffer.get();
            byte by3 = byteBuffer.get();
            byte by4 = byteBuffer.get();
            if (by == 0 && by2 == 0 && by3 == 0 && by4 == 1) {
                byteBuffer.order(ByteOrder.BIG_ENDIAN);
            }
            if (by != 0 || by2 != 0 || by3 != 1 || by4 != 0) {
                throw new IOException("Illegal start of data file \"" + file4 + "\": " + by + ", " + by2 + ", " + by3 + ", " + by4);
            }
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 2; i < n4; ++i) {
                short s = byteBuffer.getShort();
                if (!blArray[i]) continue;
                sArrayArray[i][n] = s;
            }
        }
        SignalDataSetWriter signalDataSetWriter = new SignalDataSetWriter(file3, n2, n3, listSeries);
        for (int i = 0; i < n4; ++i) {
            if (!blArray[i]) continue;
            signalDataSetWriter.addPixelSignal(new PixelSignal(0, i, sArrayArray[i]));
        }
        signalDataSetWriter.close();
    }

    private static void fillBuffer(ByteBuffer byteBuffer, File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileChannel fileChannel = fileInputStream.getChannel();
        byteBuffer.clear();
        while (byteBuffer.hasRemaining()) {
            if (fileChannel.read(byteBuffer) != -1) continue;
            throw new EOFException("Unexpected EOF in file \"" + file + "\"");
        }
        fileInputStream.close();
        byteBuffer.flip();
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.mri.CreateSignalDataSet <timesfile> <maskfile> <signalfile>");
        System.err.println("<timesfile> = Input times file");
        System.err.println("<maskfile> = Input mask file");
        System.err.println("<signalfile> = Output spin signal data set file");
        System.exit(1);
    }
}

