/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.util.Random;

public class BernoulliPrng {
    private final Random myUniformPrng;
    private final double myP;

    public BernoulliPrng(Random random) {
        this(random, 0.5);
    }

    public BernoulliPrng(Random random, double d) {
        if (random == null) {
            throw new NullPointerException("BernoulliPrng(): theUniformPrng is null");
        }
        if (0.0 > d || d > 1.0) {
            throw new IllegalArgumentException("BernoulliPrng(): p = " + d + " illegal");
        }
        this.myUniformPrng = random;
        this.myP = d;
    }

    public boolean next() {
        return this.myUniformPrng.nextDouble() < this.myP;
    }
}

