## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>"
)

options(
  tibble.print_min = 4L, 
  tibble.print_max = 4L, 
  rmarkdown.html_vignette.check_title = FALSE
)

## ----setup, message = FALSE---------------------------------------------------
library(tidytof)
library(dplyr)

## -----------------------------------------------------------------------------
tidytof_example_data()

## -----------------------------------------------------------------------------
tidytof_example_data("phenograph")

## -----------------------------------------------------------------------------
phenograph <-
    tidytof_example_data("phenograph") %>%
    tof_read_data()

phenograph %>%
    class()

## -----------------------------------------------------------------------------
phenograph %>%
    tof_get_panel()

## -----------------------------------------------------------------------------
phenograph <-
    phenograph %>%
    # mutate the input tof_tbl
    mutate(
        PhenoGraph = as.character(PhenoGraph),
        Condition = as.character(Condition)
    )

phenograph %>%
    # use dplyr's select method to show
    # that the columns have been changed
    select(where(is.character))

## -----------------------------------------------------------------------------
phenograph %>%
    class()

## -----------------------------------------------------------------------------
# when csv files are read, the tof_tibble's "panel"
# attribute will be empty by default
tidytof_example_data("phenograph_csv") %>%
    tof_read_data() %>%
    tof_get_panel()

# to add a panel manually, provide it as a tibble
# to tof_read_data
phenograph_panel <-
    phenograph %>%
    tof_get_panel()

tidytof_example_data("phenograph_csv") %>%
    tof_read_data(panel_info = phenograph_panel) %>%
    tof_get_panel()

## -----------------------------------------------------------------------------
data(phenograph_data)

print(phenograph_data)

## ----eval = FALSE-------------------------------------------------------------
# # when copying and pasting this code, feel free to change this path
# # to wherever you'd like to save your output files
# my_path <- file.path("~", "Desktop", "tidytof_vignette_files")
# 
# phenograph_data %>%
#     tof_write_data(
#         group_cols = phenograph_cluster,
#         out_path = my_path,
#         format = "fcs"
#     )

## -----------------------------------------------------------------------------
phenograph_data %>%
    distinct(phenograph_cluster)

## ----eval = FALSE-------------------------------------------------------------
# phenograph_data %>%
#     # create a variable representing if a cell is above or below
#     # the median expression level of pstat5
#     mutate(
#         expression_group = if_else(pstat5 > median(pstat5), "high", "low")
#     ) %>%
#     tof_write_data(
#         group_cols = c(phenograph_cluster, expression_group),
#         out_path = my_path,
#         format = "fcs"
#     )

## -----------------------------------------------------------------------------
phenograph_data %>%
    mutate(
        expression_group = if_else(pstat5 > median(pstat5), "high", "low")
    ) %>%
    distinct(phenograph_cluster, expression_group)

## -----------------------------------------------------------------------------
sessionInfo()

