% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ABneutral.R
\name{ABneutral}
\alias{ABneutral}
\title{Run Model with no selection (ABneutral)}
\usage{
ABneutral(pedigree.data, p0uu, eqp, eqp.weight, Nstarts, out.dir, out.name)
}
\arguments{
\item{pedigree.data}{pedigree data.}

\item{p0uu}{initial proportion of unmethylated cytosines.}

\item{eqp}{equilibrium proportion of unmethylated cytosines.}

\item{eqp.weight}{weight assigned to equilibrium function.}

\item{Nstarts}{iterations for non linear LSQ optimization.}

\item{out.dir}{output directory.}

\item{out.name}{output file name.}
}
\value{
ABneutral RData file.
}
\description{
This model assumes that heritable gains and losses in cytosine methylation are selectively neutral.
}
\examples{
#Get some toy data
inFile <- readRDS(system.file("extdata/dm/","output.rds", package="AlphaBeta"))
pedigree <- inFile$Pdata
p0uu_in <- inFile$tmpp0
eqp.weight <- 1
Nstarts <- 2
out.name <- "CG_global_estimates_ABneutral"
out <- ABneutral(pedigree.data = pedigree,
                  p0uu=p0uu_in,
                  eqp=p0uu_in,
                  eqp.weight=eqp.weight,
                  Nstarts=Nstarts,
                  out.dir=getwd(),
                  out.name=out.name)

summary(out)

}
