% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildPedigree.R
\name{buildPedigree}
\alias{buildPedigree}
\title{Building Pedigree}
\usage{
buildPedigree(nodelist, edgelist, cytosine = "CG", posteriorMaxFilter = 0.99)
}
\arguments{
\item{nodelist}{input file containing information on generation times and pedigree lineages
"extdata" called "nodelist.fn"}

\item{edgelist}{input file containing edges}

\item{cytosine}{Type of cytosine (CHH/CHG/CG)}

\item{posteriorMaxFilter}{Filter value, based on posteriorMax}
}
\value{
generating divergence matrices file.
}
\description{
calculate divergence times of the pedigree
}
\examples{
# Get some toy data
file <- system.file("extdata/dm/","nodelist.fn", package="AlphaBeta")
df<-read.csv(file)
df$filename <- gsub("^", paste0(dirname(dirname(file)),"/"), df$filename )
write.csv(df, file = paste0(dirname(file),"/", "tmp_nodelist.fn"), row.names=FALSE, quote=FALSE)
file <- system.file("extdata/dm/","tmp_nodelist.fn", package="AlphaBeta")
file2 <- system.file("extdata/dm/","edgelist.fn", package="AlphaBeta")
buildPedigree(nodelist = file, edgelist=file2, cytosine="CG", posteriorMaxFilter=0.99)
}
