% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gadgets.R
\name{avworkspace_gadget}
\alias{avworkspace_gadget}
\alias{browse_workspace}
\alias{avtable_gadget}
\alias{avworkflow_gadget}
\title{Graphical user interfaces for common AnVIL operations}
\usage{
avworkspace_gadget()

browse_workspace(use_avworkspace = TRUE)

avtable_gadget()

avworkflow_gadget()
}
\arguments{
\item{use_avworkspace}{logical(1) when \code{TRUE} (default), use the
selected workspace (via \code{workspace()} or \code{avworkspace()} if
available. If \code{FALSE} or no workspace is currently selected,
use \code{workspace()} to allow the user to select the workspace.}
}
\value{
\code{workspace()} returns the selected workspace as a
character(1) using the format namespace/name, or character(0)
if no workspace is selected.

\code{browse_workspace()} returns the status of a \code{system()}
call to launch the browser, invisibly.

\code{table()} returns a \code{tibble} representing the selected
AnVIL table.

\code{workflow()} returns an \code{avworkflow_configuration} object
representing the inputs and outputs of the selected
workflow. This can be edited and updated as described in the
"Running an AnVIL workflow within R" vigenette.
}
\description{
\code{workspace()} allows choice of workspace for
subsequent use. It is the equivalent of displaying workspaces
with \code{avworkspaces()}, and setting the selected workspace with
\code{avworkspace()}.

\code{browse_workspace()} uses \code{browseURL()} to open a
browser window pointing to the Terra workspace.

\code{table()} allows choice of table in the current
workspace (selected by \code{avworkspace()} or \code{workspace()}) to be
returned as a tibble. It is equivalent to invoking \code{avtables()}
to show available tables, and \code{avtable()} to retrieve the
selected table.

\code{workflow()} allows choice of workflow for
retrieval. It is the equivalent of \code{avworkflows()} for listing
available workflows, and \code{avworkflow_configuration_get()} for
retrieving the workflow.
}
\examples{
\dontshow{if (has_avworkspace(TRUE, platform = AnVILGCP::gcp())) withAutoprint(\{ # examplesIf}
workspace()
browse_workspace(use_avworkspace = FALSE)
tbl <- table()
wkflw <- avworkflow_gadget()
\dontshow{\}) # examplesIf}
}
