% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{check_gff}
\alias{check_gff}
\title{Check inputs to tr2g_gtf and tr2g_gff3}
\usage{
check_gff(format, file, transcript_id, gene_id)
}
\arguments{
\item{format}{Whether it's gtf or gff3.}

\item{file}{Path to a GTF file to be read. The file can remain gzipped. Use
\code{getGTF} from the \code{biomartr} package to download GTF files
from Ensembl, and use \code{getGFF} from \code{biomartr} to download
GFF3 files from Ensembl and RefSeq.}

\item{transcript_id}{Character vector of length 1. Tag in \code{attribute}
field corresponding to transcript IDs. This argument must be supplied and
cannot be \code{NA} or \code{NULL}. Will throw error if tag indicated in this
argument does not exist.}

\item{gene_id}{Character vector of length 1. Tag in \code{attribute}
field corresponding to gene IDs. This argument must be supplied and
cannot be \code{NA} or \code{NULL}. Note that this is different from gene
symbols, which do not have to be unique. This can be Ensembl or Entrez IDs.
However, if the gene symbols are in fact unique for each gene, you may
supply the tag for human readable gene symbols to this argument. Will throw
error if tag indicated in this argument does not exist. This is typically
"gene_id" for annotations from Ensembl and "gene" for refseq.}
}
\value{
Nothing, will throw error if there's a problem.
}
\description{
This function validates inputs to tr2g_gtf and tr2g_gff3 and throws error
early if some inputs are wrong.
}
