% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CAEN.R
\name{CAEN}
\alias{CAEN}
\title{Compute the correlation coefficient of gene with category number to identify
differentially expressed genes}
\usage{
CAEN(dataTable, y, K, gene_no_list)
}
\arguments{
\item{dataTable}{would be a SummarizedExperiment Bioconductor object, then 
it would be transformed into a p times n matrix - i.e. features on the rows 
and observations on the columns in the function, or dataTable would be a p 
times n matrix.}

\item{y}{the category for each sample}

\item{K}{the number of class}

\item{gene_no_list}{the number of differentially expressed genes you want
to select}
}
\value{
list(.) A list of computed correlation coefficient and the first some
differentially expressed genes , where "r" represents correlation coefficient
 between gene and category number, and "np" represents the top differential
 feature label.
}
\description{
To Compute the correlation coefficient of gene with category
number to identify  differentially expressed genes.
}
\examples{
library(SummarizedExperiment)
dat <- newCountDataSet(n=40,p=500,sdsignal=0.1,K=4,param=10,drate=0.4)
x <- dat$sim_train_data         
y <- as.numeric(colnames(dat$sim_train_data))      
myscore <- CAEN(dataTable=x, y=y, K=4, gene_no_list=100)
}
