% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleGenesVsCells.R
\name{meanGeneClusterOnCellUMAP}
\alias{meanGeneClusterOnCellUMAP}
\title{Mean gene cluster on cell umap}
\usage{
meanGeneClusterOnCellUMAP(f, fPrime, geneCluster)
}
\arguments{
\item{f}{\itemize{
\item a Seurat object of cells or SingleCellExperiment to
be converted to a Seurat object
}}

\item{fPrime}{\itemize{
\item the corresponding Seurat object of genes
SingleCellExperiment to be converted to a Seurat object
}}

\item{geneCluster}{\itemize{
\item a gene cluster of fPrime
}}
}
\value{
This returns a ggplot object
}
\description{
This function paints gene expression for a
given gene cluster on cell umap.
}
\examples{
getExample = make.getExample()
exSeuratObj = getExample('exSeuratObj',toy=TRUE)
STranspose = getExample('STranspose',toy=TRUE)
g = meanGeneClusterOnCellUMAP(exSeuratObj,STranspose,geneCluster=0)
}
