% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwmAlignment.R
\name{localPwmAlignment}
\alias{localPwmAlignment}
\title{Align pwms}
\usage{
localPwmAlignment(pwm_left, pwm_right, divergence = shannonDivergence,
  unaligned_penalty = divergencePenaltyForUnaligned,
  try_reverse_complement = TRUE, base_distribution = NULL,
  length_normalization = FALSE)
}
\arguments{
\item{pwm_left}{first PWM, a matrix of type matrix}

\item{pwm_right}{first PWM, a matrix of type matrix}

\item{divergence}{is a measure of difference between two pwm columns. Smaller is more similar. If you want to use non-uniform background distribution, provide your own function.}

\item{unaligned_penalty}{distance for unaligned columns at edges of matrixes. See divergencePenaltyForUnaligned as an example for providing your own function}

\item{try_reverse_complement}{If false the alignment will not be performed on reverse complements. If true, the input pwms should have column order of ACTG/ACGU.}

\item{base_distribution}{is a vector of length nrow(pwm) that is added to unaligned columns of pwms for comparing. If NULL, uniform distribution is used}

\item{length_normalization}{If true, will minimize the average divergence between PWMs. Otherwise will minimize the sum of divergences between positions. In both cases unalignes positions are compared to base_distribution and are counted when computing the alignment length.}
}
\value{
list of length two containing the alignment and the divergence
}
\description{
Finds best local alignment for two PWMs.
}
\author{
Lando Andrey
}
