% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{GbsrGenotypeData-class}
\alias{GbsrGenotypeData-class}
\alias{GbsrGenotypeData}
\title{Class \link{GbsrGenotypeData}}
\description{
The \link{GbsrGenotypeData} class is the main class of \link{GBScleanR} and
user work with this class object.
}
\details{
The \link{GbsrGenotypeData} class is an extention of \code{\link[SeqArray]{SeqVarGDSClass-class}} in the
\code{SeqArray} package to store summary data of genotypes and reads and a
\link{GbsrScheme} object that contains mating scheme information of the given
population..
The slots \code{marker} and \code{sample} store a \link{data.frame} object for variant-wise
and sample-wise summary information, respectively. The \code{scheme} slot holds a
\link{GbsrScheme} object. The function \code{\link[=loadGDS]{loadGDS()}} initialize the
\link{GbsrGenotypeData} class.
}
\section{Slots}{

\describe{
\item{\code{marker}}{A \link{data.frame} object.}

\item{\code{sample}}{A \link{data.frame} object.}

\item{\code{scheme}}{A \link{GbsrScheme} object.}
}}

\examples{
# [loadGDS()] initialize the [GbsrGenotypeData] object.

# Load a GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

# Close connection to the GDS file.
closeGDS(gds)

}
