% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{closeGDS}
\alias{closeGDS}
\alias{closeGDS,GbsrGenotypeData-method}
\title{Close the connection to the GDS file}
\usage{
closeGDS(object, save_filter = FALSE, verbose = TRUE, ...)

\S4method{closeGDS}{GbsrGenotypeData}(object, save_filter, verbose)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{save_filter}{A logical whether to save the filtering information made
via \code{\link[=setSamFilter]{setSamFilter()}} and \code{\link[=setMarFilter]{setMarFilter()}} in the GDS file. The saved
filter information can be reused if set \code{load_filter = TRUE} for
\code{\link[=loadGDS]{loadGDS()}}.}

\item{verbose}{if TRUE, show information.}

\item{...}{Unused.}
}
\value{
NULL.
}
\description{
Close the connection to the GDS file linked to the given
\link{GbsrGenotypeData} object.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

# Close the connection to the GDS file
closeGDS(gds)

}
