% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllUtilities.R
\name{gbsrVCF2GDS}
\alias{gbsrVCF2GDS}
\title{Convert a VCF file to a GDS file}
\usage{
gbsrVCF2GDS(
  vcf_fn,
  out_fn,
  gt = "GT",
  info.import = NULL,
  fmt.import = NULL,
  force = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{vcf_fn}{A string to indicate path to an input VCF file.}

\item{out_fn}{A string to indicate path to an output GDS file.}

\item{gt}{the ID for genotypic data in the FORMAT column; "GT" by default,
VCFv4.0.}

\item{info.import}{characters, the variable name(s) in the INFO field for
import; or NULL for all variables. If you specify \code{character(0)}, nothing
will be retrieved from the INFO filed.}

\item{fmt.import}{characters, the variable name(s) in the FORMAT field for
import; or NULL for all variables. If you specify \code{character(0)}, nothing
will be retrieved from the FORMAT filed, except for GT.}

\item{force}{A logical value to overwrite a GDS file even if
the file specified in "out_fn" exists.}

\item{verbose}{if TRUE, show information.}
}
\value{
The output GDS file path.
}
\description{
This function converts a variant call data in the VCF format.
The current implementation only accepts biallelic
single nucleotide polymorphisms.
Please filter out variants which are insertions and
deletions or multiallelic.
You may use "bcftools" or "vcftools" for filtering.
}
\details{
gbsrVCF2GDS converts a VCF file to a GDS file.
The data structure of the GDS file created via this functions is same with
those created by \code{\link[SeqArray]{seqVCF2GDS}} of \code{SeqArray}.
}
\examples{
# Create a GDS file from a sample VCF file.
vcf_fn <- system.file("extdata", "sample.vcf", package = "GBScleanR")
gds_fn <- tempfile("sample", fileext = ".gds")
gbsrVCF2GDS(vcf_fn = vcf_fn, out_fn = gds_fn, force = TRUE)

# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds <- loadGDS(gds_fn)

# Close the connection to the GDS file.
closeGDS(gds)

}
