% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{makeScheme}
\alias{makeScheme}
\alias{makeScheme,GbsrGenotypeData-method}
\title{Automate a \link{GbsrScheme} object building.}
\usage{
makeScheme(object, generation, crosstype, ...)

\S4method{makeScheme}{GbsrGenotypeData}(object, generation, crosstype)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{generation}{An integer to indicate which generation of selfing or
sibling-crossing your population is.}

\item{crosstype}{A string to indicate the type of
cross conducted with a given generation.}

\item{...}{Unused.}
}
\value{
A \link{GbsrGenotypeData} object storing
a \link{GbsrScheme} object in the "scheme" slot.
}
\description{
\link{GBScleanR} uses breeding scheme information to set the expected
number of cross overs in a chromosome which is a required parameter
for the genotype error correction with the Hidden Markov model
implemented in the \code{estGeno()} function.
This function automates the building of a \link{GbsrScheme} object.
}
\details{
A scheme object is just a data.frame indicating a population size and
a type of cross applied to each generation of the breeding process
to generate the population which you are going to subject
to the \code{\link[=estGeno]{estGeno()}} function.
The \code{crosstype} specified to \code{\link[=makeScheme]{makeScheme()}} can take "selfing" and "sibling".
When your population has $2^n$ parents specified by \code{\link[=setParents]{setParents()}},
\code{\link[=makeScheme]{makeScheme()}} assumes those parents were crossed in the "funnel" design in
which $2^n$ parents are crossed to obtain $2^n/2$ F1 hybrids followed by
successive intercrossings (pairings) of the hybrids to combine the genomes
of all parents in one family of siblings. The \code{\link[=makeScheme]{makeScheme()}} function assumes
that the parents that were assigned an odd number member ID (N) in
\code{\link[=setParents]{setParents()}} had been crossed with the parent that were assigned an even
number (N+1). For example, if you set parents as shown below. The
\code{\link[=makeScheme]{makeScheme()}} function prepare a scheme information that indicates the
intercrossings of "p1 x p2", "p3 x p4", "p5 x p6", and "p7 x p8" followed by
crossing of "p1xp2_F1 x p3xp4_F1" and "p5xp6_F1 x p7xp8_F1" and then crossing
of the two 4-way crossed liens to produce 8-way crossed hybrid lines. If,
for example, \code{generation = 5} indicating an F5 generation was specified to
\code{\link[=makeScheme]{makeScheme()}}, the function adds 4 successive selfing or sibling crossings
in the scheme. The created \link{GbsrScheme} object will be set in the \code{scheme}
slot of the \link{GbsrGenotypeData} object.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

# Biparental F2 population.
gds <- setParents(gds, parents = c("Founder1", "Founder2"))

gds <- makeScheme(gds, generation = 2, crosstype = "self")

############################################################################
# Now you can execute `estGeno()` which requires a [GbsrScheme] object.

# Close the connection to the GDS file
closeGDS(gds)
}
\seealso{
\code{\link[=initScheme]{initScheme()}}, \code{\link[=addScheme]{addScheme()}}, and \code{\link[=showScheme]{showScheme()}}
}
