% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{reopenGDS}
\alias{reopenGDS}
\alias{reopenGDS,GbsrGenotypeData-method}
\title{Reopen the connection to the GDS file.}
\usage{
reopenGDS(object, ...)

\S4method{reopenGDS}{GbsrGenotypeData}(object)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{...}{Unused.}
}
\value{
A \link{GbsrGenotypeData} object.
}
\description{
Reopen the connection to the GDS file.
}
\details{
The GbsrGenotypeData object stores the file path of the GDS file
even after closing the connection the file. This function open again the
connection to the GDS file at the file path stored in the GbsrGenotypeData
object. If the GbsrGenotypeData object witch has an open connection to
the GDS file, this function will reopen the connection. The data stored in
the marker and sample slots will not be changed.
Thus, you can open a connection with the GDS file with keeping information
of filtering and summary statistics.
}
\examples{
# Use a GDS file of example data.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")

# Instantiation of [GbsrGenotypeData]
gds <- loadGDS(gds_fn)

# Close the connection to the GDS file
closeGDS(gds)

gds <- reopenGDS(gds)

# Close the connection to the GDS file
closeGDS(gds)
}
