% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{setParents}
\alias{setParents}
\alias{setParents,GbsrGenotypeData-method}
\title{Set labels to samples which should be recognized as
parents of the population to be subjected to error correction.}
\usage{
setParents(object, parents, nonmiss = FALSE, mono = FALSE, bi = FALSE, ...)

\S4method{setParents}{GbsrGenotypeData}(object, parents, nonmiss, mono, bi)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{parents}{A vector of strings with at least length two.
The specified strings should match with the samples
ID available via \code{\link[=getSamID]{getSamID()}}.}

\item{nonmiss}{A logical value whether to filter out markers which
are missing in parents.}

\item{mono}{A logical value whether to filter out markers which
are not monomorphic in parents.}

\item{bi}{A logical value whether to filter out marekrs which
are not biallelic between parents.}

\item{...}{Unused.}
}
\value{
A \link{GbsrGenotypeData} object with parents information.
}
\description{
Specify two or more samples in the dataset as parents
of the population. Markers will be filtered out up on your specification.
}
\details{
The \code{clean} function of \link{GBScleanR} uses read count information of
samples and their parents separately to estimate most probable
genotype calls of them. Therefore, you must specify proper samples
as parents via this function. If you would like to remove SNP markers
which are not biallelic and/or not monomorphic in each parent,
set \code{mono = TRUE} and \code{bi = TRUE}. The replicates of parental samples
specified to the \code{repliate} argument of \code{\link[=setParents]{setParents()}} will have the same
genotypes at all markers in the estimated genotypes obtained via \code{\link[=estGeno]{estGeno()}}.
In the genotype estimation by \code{\link[=estGeno]{estGeno()}}, the Viterbi scores for each
possible genotype at each marker for the replicates will be replaced with
the average score for the replicates.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

# Find the IDs of parental samples.
parents <- grep("Founder", getSamID(gds), value = TRUE)

# Set the parents and flip allele information
# if the reference sample (Founder1 in our case) has homozygous
# alternative genotype at some markers of which alleles will
# be swapped to make the reference sample have homozygous
# reference genotype.
gds <- setParents(gds, parents = parents)

# Initialize a scheme object stored in the slot of the GbsrGenotypeData.
# We chose `crosstype = "pair"` because two inbred founders were mated
# in our breeding scheme.
# We also need to specify the mating matrix which has two rows and
# one column with integers 1 and 2 indicating a sample (founder)
# with the memberID 1 and a sample (founder) with the memberID 2
# were mated.
gds <- initScheme(gds, mating = cbind(c(1:2)))

# Add information of the next cross conducted in our scheme.
# We chose 'crosstype = "selfing"', which do not require a
# mating matrix.
gds <- addScheme(gds, crosstype = "selfing")

# Execute error correction by estimating genotype and haplotype of
# founders and offspring.
gds <- estGeno(gds)

# Close the connection to the GDS file.
closeGDS(gds)

}
