% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{validSam}
\alias{validSam}
\alias{validSam<-}
\alias{validSam,GbsrGenotypeData-method}
\alias{validSam<-,GbsrGenotypeData-method}
\title{Return a logical vector indicating which are valid samples.}
\usage{
validSam(object, parents = FALSE, ...)

validSam(object) <- value

\S4method{validSam}{GbsrGenotypeData}(object, parents)

\S4method{validSam}{GbsrGenotypeData}(object) <- value
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{parents}{A logical value to indicate to set FALSE or TRUE
to parental samples. If you specify \code{parents = "only"}, this
function returns a logical vector indicating TRUE for only parental samples.}

\item{...}{Unused.}

\item{value}{A logical vector indicating valid samples with the length
matching with the number of samples}
}
\value{
A logical vector of the same length
with the number of total samples.
}
\description{
Return a logical vector indicating which are valid samples.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

validSam(gds)

# Close the connection the GDS file.
closeGDS(gds)

}
