% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findGO.R
\name{findGO}
\alias{findGO}
\title{Find top Gene Ontology terms for given genes.}
\usage{
findGO(groups, topAOV = 50, sig.levelAOV = 0.05, parallel = FALSE,
  grouped = "tukey", sig.levelGO = 0.05, minGO = 5, maxGO = 500,
  clust.metric = NULL, clust.method = NULL, dist.matrix = NULL,
  topGO = 3, sig.levelTUK = 0.05, onto = c("MF", "BP", "CC"),
  extend = FALSE, over.rep = FALSE)
}
\arguments{
\item{groups}{a MultiAssayExperiment object
containing an ExperimentList class object representing
gene expressions for at least 3 cohorts.
 Rows must be named with genes' aliases.
 The order of samples and genes has to be the same for each
 ExperimentList class object.}

\item{topAOV}{A numeric value, a number of most
significantly differentiated genes to be returned.}

\item{sig.levelAOV}{a numeric value, a significance level
used in BH correction for multiple testing (\code{aovTopTest}).}

\item{parallel}{A logical value indicating if a task
should be run on more than one core.}

\item{grouped}{A method of grouping genes, one of 'tukey' and 'clustering'.}

\item{sig.levelGO}{A numeric value, a significance level used
in BH correction for multiple testing (\code{findTopGOs}).}

\item{minGO}{A minimum number of functions that a gene
needs to represent to be considered as frequent.}

\item{maxGO}{A maximum number of functions that a gene
needs to represent to be considered as frequent.}

\item{clust.metric}{The method to calculate a distance measure
used in hierarchical clustering, possible names: "euclidean",
"maximum", "manhattan", "canberra", "binary" or "minkowski".}

\item{clust.method}{The agglomeration method used to cluster genes.
This should be #'one of "ward.D",
"ward.D2", "single", "complete", "average" (= UPGMA),
"mcquitty" (= WPGMA), "median" (= WPGMC) or "centroid" (= UPGMC).}

\item{dist.matrix}{A matrix with calculated distances to be
used as a metric by \code{hclust} function.}

\item{topGO}{A number of the most characteristic functions
of groups of genes to be returned.}

\item{sig.levelTUK}{A numeric value, a significance level used in
Tukey's all pairwise comparison (\code{groupByTukey}).}

\item{onto}{An ontology or ontologies to be searched
for significant GO terms,
at least one of 'MF' (molecular function),
'BP' (biological process), and 'CC' (cellular component).}

\item{extend}{A logical value indicating if an extended
version of the output should be presented.}

\item{over.rep}{A logical value indicating if an over
represented GO terms should be presented in the plot.}
}
\value{
A data frame containing the top gene ontology terms for
 each group of genes and the gene aliases.
}
\description{
Find top Gene Ontology terms for given genes.
}
\examples{
findGO(exrtcga, grouped = 'clustering', topGO = 10, onto = 'MF')
findGO(exrtcga, grouped = 'tukey', topGO = 2, extend = TRUE)
}
