% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsvaNewAPI.R
\name{geneIdsToGeneSetCollection}
\alias{geneIdsToGeneSetCollection}
\title{Construct a GeneSetCollection object from a list of character vectors}
\usage{
geneIdsToGeneSetCollection(
  geneIdsList,
  geneIdType = "auto",
  collectionType = NullCollection()
)
}
\arguments{
\item{geneIdsList}{A named list of character vectors like the ones returned
by \code{geneIds()}.  Names must be unique; otherwise see \code{deduplicateGeneSets()}
for a number of strategies to resolve this issue.}

\item{geneIdType}{By default a character vector of length 1 with the special
value \code{"auto"} or an object of a subclass of \code{GeneIdentifierType}.  If set
to \code{"auto"}, the function will try to derive the gene ID type from argument
\code{geneIdsList} using \code{\link{guessGeneIdType}}.
Other values, including \code{NULL}, will be ignored with a warning and
\code{geneIdType=NullIdentifier()} will be used instead.
The gene ID type of all \code{GeneSet} objects in the resulting
\code{GeneSetCollection} will be set to this value.}

\item{collectionType}{An object of class \code{CollectionType}.  The collection
type of all \code{GeneSet} objects in the resulting \code{GeneSetCollection} will be
set to this value but can afterwards be modified for individual \code{GeneSet}s
if necessary.}
}
\value{
An object of class \code{GeneSetCollection} with all its \code{GeneSet}
objects using the gene ID and collection types specified by the corresponding
arguments.  Applying function \code{geneIds()} to this object should return a list
identical to the \code{geneIdsList} argument.
}
\description{
This function is essentially the reverse of
\code{GSEABase::geneIds()}, i.e., it takes as input a named list of \code{character}
vectors representing gene sets and returns the corresponding
GeneSetCollection object.
}
\examples{

library(GSVA)

gsets <- list(INNATE_RESPONSE=c("AIM2", "ALPK1", "AP3B1"),
              ADAPTIVE_RESPONSE=c("CD27", "CD70", "EBAG9"))
gsets
geneIdsToGeneSetCollection(gsets)

}
\seealso{
\code{\link[GSEABase:GeneSetCollection-class]{GeneSetCollection}},
\code{\link[GSEABase:GeneIdentifierType-class]{GeneIdentifierType}},
\code{\link[GSEABase:GeneSet-class]{geneIds}},
\code{\link{deduplicateGeneSets}},
\code{\link{guessGeneIdType}},
\code{\link[GSEABase:GeneSet-class]{GeneSet}}
}
