% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OverlapFunctions.R
\name{findDEXexonType}
\alias{findDEXexonType}
\title{Find a DEXSeq exons' biotype}
\usage{
findDEXexonType(DEXSeqExonId, DEXSeqGtf, gtf, set = "overlap")
}
\arguments{
\item{DEXSeqExonId}{vector of DEXSeq exon ids}

\item{DEXSeqGtf}{GRanges object of the DEXSeq formatted gtf}

\item{gtf}{GRanges object of the GTF annotated with exon biotypes - i.e. exon, CDS, UTR}

\item{set}{which overlapping set of exon biotypes to return - to, from, and/or overlap}
}
\value{
overlaping types
}
\description{
Find a DEXSeq exons' biotype
}
\examples{
gtfFile <- system.file("extdata","example_gtf.gtf",
package = "GeneStructureTools")
DEXSeqGtfFile <- system.file("extdata","gencode.vM14.dexseq.gtf",
package = "GeneStructureTools")

gtf <- rtracklayer::import(gtfFile)
gtf <- UTR2UTR53(gtf)
DEXSeqGtf <- rtracklayer::import(DEXSeqGtfFile)

findDEXexonType("ENSMUSG00000032366.15:E028", DEXSeqGtf, gtf)

DEXSeqResultsFile <- system.file("extdata","dexseq_results_significant.txt",
package = "GeneStructureTools")
DEXSeqResults <- read.table(DEXSeqResultsFile, sep="\\t")

findDEXexonType(rownames(DEXSeqResults), DEXSeqGtf, gtf)

}
\seealso{
Other DEXSeq processing methods: \code{\link{DEXSeqIdsToGeneIds}},
  \code{\link{summariseExonTypes}}
}
\author{
Beth Signal
}
