% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot_5parts_metagene.R
\name{plot_5parts_metagene}
\alias{plot_5parts_metagene}
\title{Plot promoter, 5'UTR, CDS, 3'UTR and TTS}
\usage{
plot_5parts_metagene(
  queryFiles,
  gFeatures_list,
  inputFiles = NULL,
  importParams = NULL,
  verbose = FALSE,
  transform = NA,
  smooth = FALSE,
  scale = FALSE,
  stranded = TRUE,
  outPrefix = NULL,
  heatmap = FALSE,
  heatRange = NULL,
  rmOutlier = 0,
  Ylab = "Coverage/base/gene",
  hw = c(10, 10),
  nc = 2
)
}
\arguments{
\item{queryFiles}{a vector of sample file names. The file should be in .bam,
.bed, .wig or .bw format, mixture of formats is allowed}

\item{gFeatures_list}{a list of genomic features as output of the function
\code{\link{prepare_5parts_genomic_features}}}

\item{inputFiles}{a vector of input sample file names. The file should be in
.bam, .bed, .wig or .bw format, mixture of formats is allowed}

\item{importParams}{a list of parameters for \code{handle_input}}

\item{verbose}{logical, indicating whether to output additional information
(data used for plotting or statistical test results)}

\item{transform}{logical, whether to log2 transform the matrix}

\item{smooth}{logical, indicating whether the line should smoothed with a
spline smoothing algorithm}

\item{scale}{logical, indicating whether the score matrix should be scaled to
the range 0:1, so that samples with different baseline can be compared}

\item{stranded}{logical, indicating whether the strand of the feature should
be considered}

\item{outPrefix}{a string specifying output file prefix for plots
(outPrefix.pdf)}

\item{heatmap}{logical, indicating whether a heatmap of the score matrix
should be generated}

\item{heatRange}{a numeric vector with three elements, defining custom range for
color ramp, default=NULL, i.e. the range is defined automatically based on
the c(minimun, median, maximum) of a data matrix}

\item{rmOutlier}{a numeric value serving as a multiplier of the MAD in Hampel
filter for outliers identification, 0 indicating not removing outliers.
For Gaussian distribution, use 3, adjust based on data distribution.}

\item{Ylab}{a string for y-axis label}

\item{hw}{a vector of two elements specifying the height and width of the
output figures}

\item{nc}{integer, number of cores for parallel processing}
}
\value{
a dataframe containing the data used for plotting
}
\description{
Plot reads or peak Coverage/base/gene of samples given in the
query files around genes. The upstream and downstream windows flanking genes
can be given separately, metagene plots are generated with 5'UTR, CDS and
3'UTR segments. The length of each segments are prorated according to the
median length of each segments. If Input files are provided, ratio over Input
is computed and displayed as well.
}
\examples{

data(gf5_meta)
queryfiles <- system.file("extdata", "treat_chr19.bam",
                          package = "GenomicPlot")
names(queryfiles) <- "clip_bam"
inputfiles <- system.file("extdata", "input_chr19.bam",
                          package = "GenomicPlot")
names(inputfiles) <- "clip_input"

bamimportParams <- setImportParams(
    offset = -1, fix_width = 0, fix_point = "start", norm = TRUE,
    useScore = FALSE, outRle = TRUE, useSizeFactor = FALSE, genome = "hg19"
)

plot_5parts_metagene(
    queryFiles = queryfiles,
    gFeatures_list = list("metagene" = gf5_meta),
    inputFiles = inputfiles,
    scale = FALSE,
    verbose = FALSE,
    transform = NA,
    smooth = TRUE,
    stranded = TRUE,
    outPrefix = NULL,
    importParams = bamimportParams,
    heatmap = TRUE,
    rmOutlier = 0,
    nc = 2
)

}
\author{
Shuye Pu
}
