% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hippo.R
\name{hippo_dimension_reduction}
\alias{hippo_dimension_reduction}
\title{compute t-SNE or umap of each round of HIPPO}
\usage{
hippo_dimension_reduction(
  sce,
  method = c("umap", "tsne"),
  perplexity = 30,
  featurelevel = 1
)
}
\arguments{
\item{sce}{SingleCellExperiment object with hippo object in it.}

\item{method}{a string that determines the method for dimension
reduction: either 'umap' or 'tsne}

\item{perplexity}{numeric perplexity parameter for Rtsne function}

\item{featurelevel}{the round of clustering that you will extract
features to reduce the dimension}
}
\value{
a data frame of dimension reduction result for each
k in 1, ..., K
}
\description{
compute t-SNE or umap of each round of HIPPO
}
\examples{
data(toydata)
set.seed(20200321)
set.seed(20200321)
toydata = hippo(toydata,K = 10,z_threshold = 1,outlier_proportion = 0.01)
toydata = hippo_dimension_reduction(toydata, method="tsne")
hippo_tsne_plot(toydata)
}
