% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hippo.R
\name{zero_proportion_plot}
\alias{zero_proportion_plot}
\title{visualize each round of hippo through zero proportion plot}
\usage{
zero_proportion_plot(
  sce,
  switch_to_hgnc = FALSE,
  ref = NA,
  k = NA,
  plottitle = "",
  top.n = 5,
  pointsize = 0.5,
  pointalpha = 0.5,
  textsize = 3
)
}
\arguments{
\item{sce}{SingleCellExperiment object with hippo element in it}

\item{switch_to_hgnc}{boolean argument to indicate whether to change the gene
names from ENSG IDs to HGNC symbols}

\item{ref}{a data frame with hgnc column and ensg column}

\item{k}{select rounds of clustering that you would like to see result.
Default is 1 to K}

\item{plottitle}{Title of your plot output}

\item{top.n}{number of top genes to show the name}

\item{pointsize}{size of the ggplot point}

\item{pointalpha}{transparency level of the ggplot point}

\item{textsize}{text size of the resulting plot}
}
\value{
a ggplot object that shows the zero proportions for each round
}
\description{
visualize each round of hippo through zero proportion plot
}
\examples{
data(toydata)
set.seed(20200321)
toydata = hippo(toydata,K = 10,z_threshold = 1,outlier_proportion = 0.01)
data(ensg_hgnc)
zero_proportion_plot(toydata, switch_to_hgnc = TRUE, ref = ensg_hgnc)
}
