% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\name{SelectKClusters}
\alias{SelectKClusters}
\alias{SelectKClusters.SingleCellExperiment}
\alias{SelectKClusters,SingleCellExperiment-method}
\title{Selecting K clusters from hierarchical clustering}
\usage{
SelectKClusters.SingleCellExperiment(object, K)

\S4method{SelectKClusters}{SingleCellExperiment}(object, K = NULL)
}
\arguments{
\item{object}{of \code{SingleCellExperiment} class}

\item{K}{a positive integer denoting how many clusters to select}
}
\value{
object of \code{SingleCellExperiment} class
}
\description{
Selects K clusters from the dendrogram.
}
\examples{
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(logcounts = pbmc3k_500))
sce <- PrepareILoReg(sce)
## These settings are just to accelerate the example, use the defaults.
sce <- RunParallelICP(sce,L=2,threads=1,C=0.1,k=5,r=1)
sce <- RunPCA(sce,p=5)
sce <- HierarchicalClustering(sce)
sce <- SelectKClusters(sce,K=5)

}
\keyword{clusters}
\keyword{select}
