% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBins.R
\name{getBins}
\alias{getBins}
\title{getBins}
\usage{
getBins(chroms, ideo, binLim = NULL, stepSize)
}
\arguments{
\item{chroms}{(character) chromosomes to generate bins for}

\item{ideo}{(data.frame) ideogram table as generated by \code{getIdeo()}. See that function for details.}

\item{stepSize}{(integer) bin size in bases}

\item{binLim}{(numeric, }{length 2) [start, end] of genomic range to generate bins for. A value of NULL results in binning of entire chromosome}
}
\value{
(GRanges) bin ranges in 1-base coordinates
}
\description{
getBins
}
\details{
Get uniformly-sized bins of specified width
This is a helper function used to generate binned data for \code{plotOnIdeo()}. It takes the chromosome-wide extents from \emph{ideo}, which is essentially the \emph{cytoBandIdeo} table from UCSC browser with the header as the first row. A use case is to generate bins using this function and supply the output to \code{avgByBin()} to bin the data.
}
\examples{
ideo_hg19 <- getIdeo("hg19")
chrom_bins <- getBins(c("chr1","chr2","chrX"), ideo_hg19,stepSize=5*100*1000)
}
\seealso{
\code{getIdeo()},\code{avgByBin()}
}
