% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converters.R
\name{DIANNtoMSstatsPTMFormat}
\alias{DIANNtoMSstatsPTMFormat}
\title{Convert the output of DIA-NN PSM file into MSstatsPTM format}
\usage{
DIANNtoMSstatsPTMFormat(
  input,
  annotation,
  input_protein = NULL,
  annotation_protein = NULL,
  fasta_path = NULL,
  use_unmod_peptides = FALSE,
  protein_id_col = "Protein.Group",
  fasta_protein_name = "uniprot_ac",
  global_qvalue_cutoff = 0.01,
  qvalue_cutoff = 0.01,
  pg_qvalue_cutoff = 0.01,
  useUniquePeptide = TRUE,
  removeFewMeasurements = TRUE,
  removeOxidationMpeptides = TRUE,
  removeProtein_with1Feature = FALSE,
  MBR = TRUE,
  use_log_file = TRUE,
  append = FALSE,
  verbose = TRUE,
  log_file_path = NULL
)
}
\arguments{
\item{input}{data.frame of \code{report.tsv} file produced by Philosopher}

\item{annotation}{annotation with Run, Fraction, TechRepMixture, Mixture, Channel,
BioReplicate, Condition columns or a path to file. Refer to the example 'annotation' for the meaning of each column.}

\item{input_protein}{same as \code{input} for global profiling run. Default is NULL.}

\item{annotation_protein}{same as \code{annotation} for global profiling run. Default is NULL.}

\item{fasta_path}{A string of path to a FASTA file, used to match PTM peptides.}

\item{use_unmod_peptides}{Boolean if the unmodified peptides in the input
file should be used to construct the unmodified protein output. Only used if
\code{input_protein} is not provided. Default is \code{FALSE}.}

\item{protein_id_col}{Use 'Protein.Groups'(default) column for protein name.}

\item{fasta_protein_name}{Name of column that matches with the protein names
in \code{protein_id_col}. The protein names in these two columns must match in
order to join the FASTA file with the DIA-NN output. Default is "uniprot_ac"
for uniprot ID. For uniprot mnemonic ID, use "entry_name"}

\item{global_qvalue_cutoff}{The global qvalue cutoff. Default is 0.01.}

\item{qvalue_cutoff}{local qvalue cutoff for library. Default is 0.01.}

\item{pg_qvalue_cutoff}{local qvalue cutoff for protein groups Run should be
the same as filename. Default is 0.01.}

\item{useUniquePeptide}{logical, if TRUE (default) removes peptides that are assigned for more than one proteins.
We assume to use unique peptide for each protein.}

\item{removeFewMeasurements}{TRUE (default) will remove the features that have 1 or 2 measurements within each Run.}

\item{removeOxidationMpeptides}{TRUE (default) will remove the peptides including oxidation (M) sequence.}

\item{removeProtein_with1Feature}{TRUE will remove the proteins which have only 1 peptide and charge. Defaut is FALSE.}

\item{MBR}{If analaysis was done with match between runs or not. Default is TRUE.}

\item{use_log_file}{logical. If TRUE, information about data processing will
be saved to a file.}

\item{append}{logical. If TRUE, information about data processing will be
added to an existing log file.}

\item{verbose}{logical. If TRUE, information about data processing wil be
printed to the console.}

\item{log_file_path}{character. Path to a file to which information about
data processing will be saved. If not provided, such a file will be created
automatically. If 'append = TRUE', has to be a valid path to a file.}
}
\value{
\code{list} of one or two \code{data.frame} of class \code{MSstatsTMT}, named \code{PTM} and \code{PROTEIN}
}
\description{
Takes as input the \code{report.tsv} file from DIA-NN and converts it into
MSstatsPTM format. Requires PSM and an annotation file. Optionally an
additional \code{report.tsv} file for a corresponding global profiling run can
be included.
}
\examples{
# Example from PRIDE ID PXD053502
input = system.file("tinytest/raw_data/DIANN/report.tsv", 
                                        package = "MSstatsPTM")
input = data.table::fread(input)
annot = system.file("tinytest/raw_data/DIANN/annot.csv", 
                                        package = "MSstatsPTM")
annot = data.table::fread(annot)
fasta_path = system.file("extdata", "diann.fasta", 
                       package="MSstatsPTM")

msstatsptm_format = DIANNtoMSstatsPTMFormat(
    input, 
    annot, 
    protein_id_col = "Protein.Names", 
    fasta_path = fasta_path, 
    fasta_protein_name = "entry_name", 
    use_log_file = FALSE
)

head(msstatsptm_format$PTM)

}
