% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_sumstats.R
\name{find_sumstats}
\alias{find_sumstats}
\title{Search Open GWAS for datasets matching criteria}
\usage{
find_sumstats(
  ids = NULL,
  traits = NULL,
  years = NULL,
  consortia = NULL,
  authors = NULL,
  populations = NULL,
  categories = NULL,
  subcategories = NULL,
  builds = NULL,
  pmids = NULL,
  min_sample_size = NULL,
  min_ncase = NULL,
  min_ncontrol = NULL,
  min_nsnp = NULL,
  include_NAs = FALSE
)
}
\arguments{
\item{ids}{List of Open GWAS study IDs
(e.g. \code{c("prot-a-664", "ieu-b-4760")}).}

\item{traits}{List of traits
(e.g. \code{c("parkinson", "Alzheimer")}).}

\item{years}{List of years
(e.g. \code{seq(2015,2021)} or \code{c(2010, 2012, 2021)}).}

\item{consortia}{List of consortia
(e.g. \code{c("MRC-IEU","Neale Lab")}.}

\item{authors}{List of authors
(e.g. \code{c("Elsworth","Kunkle","Neale")}).}

\item{populations}{List of populations
(e.g. \code{c("European","Asian")}).}

\item{categories}{List of categories
(e.g. \code{c("Binary","Continuous","Disease","Risk factor"))}).}

\item{subcategories}{List of categories
(e.g. \code{c("neurological","Immune","cardio"))}).}

\item{builds}{List of genome builds
(e.g. \code{c("hg19","grch37")}).}

\item{pmids}{List of PubMed ID (exact matches only)
(e.g. \code{c(29875488, 30305740, 28240269)}).}

\item{min_sample_size}{Minimum total number of study participants
(e.g. \code{5000}).}

\item{min_ncase}{Minimum number of case participants
(e.g. \code{1000}).}

\item{min_ncontrol}{Minimum number of control participants
(e.g. \code{1000}).}

\item{min_nsnp}{Minimum number of SNPs
(e.g. \code{200000}).}

\item{include_NAs}{Include datasets with missing metadata for size criteria
(i.e. \code{min_sample_size}, \code{min_ncase}, or \code{min_ncontrol}).}
}
\value{
(Filtered) GWAS metadata table.
}
\description{
For each  argument, searches for any datasets matching
a case-insensitive substring search in the respective metadata column.
Users can supply a single character string or a
list/vector of character strings.
}
\details{
To authenticate, you need to generate a token from the OpenGWAS website. The
token behaves like a password, and it will be used to authorise the requests
you make to the OpenGWAS API. Here are the steps to generate the token and
then have \code{ieugwasr} automatically use it for your queries:
\enumerate{
\item Login to https://api.opengwas.io/profile/
\item Generate a new token
\item Add \verb{OPENGWAS_JWT=<token>} to your .Renviron file, thi can be edited in R
by running \code{usethis::edit_r_environ()}
\item Restart your R session
\item To check that your token is being recognised, run
\code{ieugwasr::get_opengwas_jwt()}. If it returns a long random string then you
are authenticated.
\item To check that your token is working, run \code{ieugwasr::user()}. It will make a
a request to the API for your user information using your token. It should
return a list with your user information. If it returns an error, then your
token is not working.
\item Make sure you have submitted use
}

By default, returns metadata for all studies currently in Open GWAS database.
}
\examples{
# Only run the examples if user has internet access
# and if access token has been added
if(try(is.character(getURL("www.google.com")))==TRUE && ieugwasr::get_opengwas_jwt()!=""){
### By ID
metagwas <- find_sumstats(ids = c(
    "ieu-b-4760",
    "prot-a-1725",
    "prot-a-664"
))
### By ID and sample size
metagwas <- find_sumstats(
    ids = c("ieu-b-4760", "prot-a-1725", "prot-a-664"),
    min_sample_size = 5000
)
### By criteria
metagwas <- find_sumstats(
    traits = c("alzheimer", "parkinson"),
    years = seq(2015, 2021)
)
}
}
