% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_tabular.R
\name{index_tabular}
\alias{index_tabular}
\title{Tabix-index file: table}
\source{
Borrowed function from
\href{https://github.com/RajLabMSSM/echotabix/blob/main/R/convert.R}{
echotabix}.
}
\usage{
index_tabular(
  path,
  chrom_col = "CHR",
  start_col = "BP",
  end_col = start_col,
  overwrite = TRUE,
  remove_tmp = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{path}{Path to GWAS summary statistics file.}

\item{chrom_col}{Name of the chromosome column in
\code{sumstats_dt} (e.g. "CHR").}

\item{start_col}{Name of the starting genomic position
column in \code{sumstats_dt} (e.g. "POS","start").}

\item{end_col}{Name of the ending genomic position
column in \code{sumstats_dt} (e.g. "POS","end").
Can be the same as \code{start_col} when \code{sumstats_dt}
only contains SNPs that span 1 base pair (bp) each.}

\item{overwrite}{A logical(1) indicating whether \code{dest} should
    be over-written, if it already exists.}

\item{remove_tmp}{Remove the temporary uncompressed version of the file
(\emph{.tsv}).}

\item{verbose}{Print messages.}
}
\value{
Path to tabix-indexed tabular file
}
\description{
Convert summary stats file to tabix format.
}
\examples{
sumstats_dt <- MungeSumstats::formatted_example() 
path <- tempfile(fileext = ".tsv")
MungeSumstats::write_sumstats(sumstats_dt = sumstats_dt, save_path = path)
indexed_file <- MungeSumstats::index_tabular(path = path)
}
\seealso{
Other tabix: 
\code{\link{index_vcf}()}
}
\concept{tabix}
