\name{OCshow}
\alias{OCshow}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Show one ore several OC curves graphically}
\description{
Plots empirical OC curves for one or several data sets simultaneously, showing the local or global false discovery rate among the top regulated genes. This is the preferred way of comparing the OC of different analyses.  
}
\usage{
OCshow(x, ..., global = TRUE, percentage = TRUE, top = 0.1, legend, lty, col, main, xlab, ylab)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x, \dots}{one or several objects created by either \code{EOC}, \code{fdr1d}, or \code{fdr2d}}
  \item{global}{logical value indicating whether to show the global or the local false discovery rates; note that if any of the objects to be plotted was created by \code{EOC}, only global Fdr is available.}
  \item{percentage}{logical switch indicating whether to show the percentage of top regulated genes or the actual numbers; note that the cutoff \code{top} is always a percentage}
  \item{top}{a value between 0 and 1 specifying the percentage of top-regulated genes that is to be shown in the plot}
  \item{legend}{a character vector giving names for each of the objects to be plotted for a legend in the left upper corner}
  \item{lty, col}{line styles and colors for the different OC curves}
  \item{main}{a plot title}
  \item{xlab, ylab}{axis labels}
}
\details{
Each object generated by \code{EOC}, \code{fdr1d}, and \code{fdr2d} lists for each gene a t-statistic and either a local or a global false discovery rate. The OC curves are constrcuted by ordering the genes according to the false discovery rates, and counting how many fall under a given threshold. These counts are plotted (either directly or as percentage of all genes) on the horzontal axis, while the thresholds are plotted on the vertical axis. Where appropriate, local false discovery rates are converted to global rates by simple averaging. 
}
%\value{
%  ~Describe the value returned
%  If it is a LIST, use
%  \item{comp1 }{Description of 'comp1'}
%  \item{comp2 }{Description of 'comp2'}
%  ...
%}
%\references{ ~put references to the literature/web site here ~ }
\author{A. Ploner}
\seealso{\code{\link{EOC}}, \code{\link{fdr1d}}, \code{\link{fdr2d}}}
\examples{
# We simulate a small example with 5 percent regulated genes and
# a rather large effect size
set.seed(2003)
xdat = matrix(rnorm(50000), nrow=1000)
xdat[1:25, 1:25] = xdat[1:25, 1:25] - 2
xdat[26:50, 1:25] = xdat[26:50, 1:25] + 2
grp = rep(c("Sample A","Sample B"), c(25,25))

# Compute the different false discovery rates
# p0 is fixed
global = EOC(xdat, grp, plot=FALSE, p0=0.95)
local1d = fdr1d(xdat, grp, p0=0.95)
local2d = fdr2d(xdat, grp, p0=0.95)

# Some possible arrangements
leg = c("global","local1d","local2d")
par(mfrow=c(2,2))
OCshow(global, local1d, local2d, legend=leg, main="Default")
OCshow(global, local1d, local2d, legend=leg, percentage=FALSE, 
       main="Number of genes")
OCshow(global, local1d, local2d, legend=leg, top=1, main="All genes")
OCshow(local1d, local2d, legend=leg[2:3], global=FALSE, main="Local fdr")


}
\keyword{aplot}% at least one, from doc/KEYWORDS
\keyword{hplot}% __ONLY ONE__ keyword per line
